/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core;

import java.util.Map;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.debug.DBGController;
import org.jkiss.dbeaver.debug.DBGControllerFactory;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.core.model.DatabaseDebugTarget;
import org.jkiss.dbeaver.debug.core.model.DatabaseProcess;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DatabaseLaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String datasourceId = configuration.getAttribute("org.jkiss.dbeaver.debug.core.ATTR_DATASOURCE_ID", null);
        DBPDataSourceContainer datasourceDescriptor = DataSourceRegistry.findDataSource((String)datasourceId);
        if (datasourceDescriptor == null) {
            String message = NLS.bind((String)"Unable to find data source with id {0}", (Object)datasourceId);
            throw new CoreException((IStatus)DebugUtils.newErrorStatus(message));
        }
        DBGController controller = this.createController(datasourceDescriptor, configuration.getAttributes());
        if (controller == null) {
            String message = NLS.bind((String)"Unable to find debug controller for datasource {0}", (Object)datasourceDescriptor);
            throw new CoreException((IStatus)DebugUtils.newErrorStatus(message));
        }
        DatabaseProcess process = this.createProcess(launch, configuration.getName());
        DatabaseDebugTarget target = this.createDebugTarget(launch, controller, process);
        target.connect(monitor);
        launch.addDebugTarget((IDebugTarget)target);
    }

    protected DBGController createController(DBPDataSourceContainer dataSourceContainer, Map<String, Object> attributes) throws CoreException {
        try {
            DBGControllerFactory controllerFactory = (DBGControllerFactory)Adapters.adapt((Object)dataSourceContainer, DBGControllerFactory.class);
            if (controllerFactory != null) {
                return controllerFactory.createController(dataSourceContainer, attributes);
            }
            throw new DBGException(NLS.bind((String)"Unable to find controller factory for datasource \"{0}\"", (Object)dataSourceContainer.getDriver().getProviderId()));
        }
        catch (DBGException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)((Object)e)));
        }
    }

    protected DatabaseProcess createProcess(ILaunch launch, String name) {
        return new DatabaseProcess(launch, name);
    }

    protected DatabaseDebugTarget createDebugTarget(ILaunch launch, DBGController controller, DatabaseProcess process) {
        return new DatabaseDebugTarget("org.jkiss.dbeaver.debug.core.database", launch, process, controller);
    }
}

