/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application.update;

import java.io.IOException;
import java.util.Calendar;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.application.update.VersionUpdateDialog;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBeaverVersionChecker
extends AbstractJob {
    private static final Log log = Log.getLog(DBeaverVersionChecker.class);
    private final boolean showAlways;

    public DBeaverVersionChecker(boolean force) {
        super("DBeaver new version release checker");
        this.showAlways = force;
        this.setUser(false);
        this.setSystem(true);
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        long lastVersionCheckTime;
        if (monitor.isCanceled() || DBeaverCore.isClosing()) {
            return Status.CANCEL_STATUS;
        }
        boolean showUpdateDialog = this.showAlways;
        if (!showUpdateDialog && (showUpdateDialog = DBeaverCore.getGlobalPreferenceStore().getBoolean("ui.auto.update.check")) && (lastVersionCheckTime = DBeaverCore.getGlobalPreferenceStore().getLong("ui.auto.update.check.time")) > 0L) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(lastVersionCheckTime);
            int checkMonth = cal.get(2);
            int checkDay = cal.get(5);
            cal.setTimeInMillis(System.currentTimeMillis());
            int curMonth = cal.get(2);
            int curDay = cal.get(5);
            if (curMonth == checkMonth && curDay == checkDay) {
                return Status.OK_STATUS;
            }
        }
        if (!this.showAlways && !showUpdateDialog) {
            return Status.OK_STATUS;
        }
        DBeaverCore.getGlobalPreferenceStore().setValue("ui.auto.update.check.time", System.currentTimeMillis());
        IProduct product = Platform.getProduct();
        if (product == null) {
            log.error((Object)"No Eclipse product found. Installation is corrupted");
            return Status.OK_STATUS;
        }
        String updateURL = product.getProperty("versionUpdateURL");
        if (updateURL == null) {
            return Status.OK_STATUS;
        }
        VersionDescriptor versionDescriptor = null;
        try {
            versionDescriptor = new VersionDescriptor((DBPPlatform)DBeaverCore.getInstance(), updateURL);
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        if (versionDescriptor != null && versionDescriptor.getProgramVersion().compareTo(GeneralUtils.getProductVersion()) > 0 && !VersionUpdateDialog.isSuppressed(versionDescriptor)) {
            this.showUpdaterDialog(versionDescriptor);
        } else if (this.showAlways) {
            this.showUpdaterDialog(null);
        }
        return Status.OK_STATUS;
    }

    private void showUpdaterDialog(VersionDescriptor versionDescriptor) {
        UIUtils.asyncExec(() -> {
            VersionUpdateDialog dialog = new VersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), versionDescriptor, !this.showAlways);
            dialog.open();
        });
    }
}

