/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.core.application.update.DBeaverVersionChecker;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.osgi.framework.Bundle;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Log log = Log.getLog(ApplicationWorkbenchAdvisor.class);
    private static final String PERSPECTIVE_ID = "org.jkiss.dbeaver.core.perspective";
    public static final String DBEAVER_SCHEME_NAME = "org.jkiss.dbeaver.defaultKeyScheme";
    private static final String WORKBENCH_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String APPEARANCE_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Views";
    protected static final String MYLYN_PREF_PAGE_ID = "org.eclipse.mylyn.preferencePages.Mylyn";
    private static final String[] EXCLUDE_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Globalization", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Perspectives", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Views/org.eclipse.ui.preferencePages.Decorators", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.ContentTypes", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Startup", "org.eclipse.mylyn.preferencePages.Mylyn", "org.eclipse.team.ui.TeamPreferences"};

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        IDE.registerAdapters();
        this.declareWorkbenchImages(configurer);
        TrayDialog.setDialogHelpAvailable((boolean)true);
    }

    private void declareWorkbenchImages(IWorkbenchConfigurer configurer) {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        String ICONS_PATH = "$nl$/icons/full/";
        String PATH_OBJECT = "$nl$/icons/full/obj16/";
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.png", true);
    }

    private void declareWorkbenchImage(IWorkbenchConfigurer configurer, Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        configurer.declareImage(symbolicName, desc, shared);
    }

    public void preStartup() {
        super.preStartup();
    }

    public void postStartup() {
        super.postStartup();
        this.filterPreferencePages();
        this.startVersionChecker();
    }

    protected boolean isPropertyChangeRequiresRestart(String property) {
        return property.equals("logs.debug.enabled") || property.equals("logs.debug.location") || property.equals("platform.language");
    }

    private void filterPreferencePages() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        String[] stringArray = this.getExcludedPreferencePageIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String epp = stringArray[n2];
            pm.remove(epp);
            ++n2;
        }
    }

    @NotNull
    protected String[] getExcludedPreferencePageIds() {
        return EXCLUDE_PREF_PAGES;
    }

    private void startVersionChecker() {
        DBeaverVersionChecker checker = new DBeaverVersionChecker(false);
        checker.schedule(3000L);
    }

    public boolean preShutdown() {
        if (!this.saveAndCleanup()) {
            return false;
        }
        return super.preShutdown();
    }

    public void postShutdown() {
        super.postShutdown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveAndCleanup() {
        IWorkbenchWindow window;
        block5: {
            window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
            if (window == null) return this.closeActiveTransactions();
            if ("never".equals(ConfirmationDialog.getSavedPreference((String)"exit")) || ConfirmationDialog.confirmAction((Shell)window.getShell(), (String)"exit")) break block5;
            return false;
        }
        try {
            IEditorReference[] editors;
            IWorkbenchPage workbenchPage = window.getActivePage();
            IEditorReference[] iEditorReferenceArray = editors = workbenchPage.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                IEditorPart editorPart = editor.getEditor(false);
                if (editorPart != null && editorPart.getEditorInput() instanceof ContentEditorInput) {
                    workbenchPage.closeEditor(editorPart, false);
                }
                ++n2;
            }
            return this.closeActiveTransactions();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean closeActiveTransactions() {
        for (DBPDataSourceContainer dataSourceDescriptor : DataSourceRegistry.getAllDataSources()) {
            if (DataSourceHandler.checkAndCloseActiveTransaction((DBPDataSourceContainer)dataSourceDescriptor)) continue;
            return false;
        }
        return true;
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        log.error((Object)"Event loop exception", exception);
    }
}

