/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.core;

import com.dbeaver.lm.core.LMPublicAPI;
import com.dbeaver.lm.core.LicenseCheckResult;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.dbeaver.Log;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMLicenseValidator;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMValidateException;

public class PublicLicenseValidator
implements LMLicenseValidator {
    public static final LMLicenseValidator PUBLIC_LICENSE_VALIDATOR = new PublicLicenseValidator();
    private static final Log log = Log.getLog(LMPublicAPI.class);
    private final Map<String, LicenseCheckResult> validateCache = new HashMap<String, LicenseCheckResult>();

    public void validateLicense(LMLicenseManager lMLicenseManager, String string, LMProduct lMProduct, LMLicense lMLicense) throws LMValidateException {
        LicenseCheckResult licenseCheckResult = this.validateCache.get(lMLicense.getLicenseId());
        if (licenseCheckResult == null) {
            try {
                licenseCheckResult = LMPublicAPI.checkLicenseStatus((IProgressMonitor)new NullProgressMonitor(), string, lMLicenseManager, lMLicense, lMProduct);
            }
            finally {
                if (licenseCheckResult != null) {
                    this.validateCache.put(lMLicense.getLicenseId(), licenseCheckResult);
                }
            }
        }
        if (licenseCheckResult == null) {
            log.error((Object)"Internal error - NULL validation result");
            return;
        }
        if (licenseCheckResult.getLicenseStatus() != LMLicenseStatus.VALID) {
            throw new LMValidateException(lMLicense, licenseCheckResult.getLicenseStatus(), licenseCheckResult.getCheckStatus().getMessage(), licenseCheckResult.getCheckStatus().getException());
        }
        if (lMLicense.isSubscription()) {
            LMSubscription lMSubscription = licenseCheckResult.getSubscription();
            if (lMSubscription == null) {
                lMSubscription = lMLicenseManager.getSubscriptionInfo(lMLicense);
            } else {
                try {
                    lMLicenseManager.updateSubscription(lMProduct, lMSubscription);
                }
                catch (LMException lMException) {
                    log.error((Object)"Can't update subscription information in the local database", (Throwable)lMException);
                }
            }
            if (lMSubscription == null) {
                throw new LMValidateException(lMLicense, LMLicenseStatus.INVALID, "Can't find subscription information for license '" + lMLicense.getLicenseId() + "'");
            }
            if (lMSubscription.isExpired()) {
                throw new LMValidateException(lMLicense, LMLicenseStatus.EXPIRED, "License '" + lMLicense.getLicenseId() + "' subscription has been expired (" + lMSubscription.getExpirationDate() + ")");
            }
        }
    }
}

