/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class MySQLForeignKeyManager
extends SQLForeignKeyManager<MySQLTableForeignKey, MySQLTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLTableForeignKey> getObjectsCache(MySQLTableForeignKey object) {
        return ((MySQLTable)object.getParentObject()).getForeignKeyCache();
    }

    protected MySQLTableForeignKey createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final MySQLTable table, Object from) {
        return (MySQLTableForeignKey)((Object)new UITask<MySQLTableForeignKey>(){

            protected MySQLTableForeignKey runTask() {
                EditForeignKeyPage editPage;
                try {
                    if ("MyISAM".equalsIgnoreCase(table.getAdditionalInfo(monitor).getEngine().getName())) {
                        DBUserInterface.getInstance().showError("Create foreign key", "Foreign keys are not supported by MyISAM engine.\nYou could change table's engine to INNODB or some other relational engine");
                        return null;
                    }
                }
                catch (DBCException e) {
                    log.error((Object)e);
                }
                if (!(editPage = new EditForeignKeyPage(MySQLMessages.edit_foreign_key_manager_title, (DBSTable)table, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT})).edit()) {
                    return null;
                }
                MySQLTableForeignKey foreignKey = new MySQLTableForeignKey(table, null, null, (MySQLTableConstraint)editPage.getUniqueConstraint(), editPage.getOnDeleteRule(), editPage.getOnUpdateRule(), false);
                foreignKey.setName(MySQLForeignKeyManager.this.getNewConstraintName(monitor, (JDBCTableConstraint)foreignKey));
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new MySQLTableForeignKeyColumn(foreignKey, (MySQLTableColumn)tableColumn.getOwnColumn(), colIndex++, (MySQLTableColumn)tableColumn.getRefColumn()));
                }
                return foreignKey;
            }
        }.execute());
    }

    protected String getDropForeignKeyPattern(MySQLTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP FOREIGN KEY %CONSTRAINT%";
    }
}

