/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc4.S4PooledConnection;
import com.vertica.jdbc.jdbc4.S4PreparedStatement;
import com.vertica.jdbc.jdbc4.S4PreparedStatementHandle;
import com.vertica.jdbc.jdbc4.utilities.WrapperUtilities;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S4ConnectionHandle
extends SConnectionHandle {
    public S4ConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        super(sConnection, sPooledConnection);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Blob createBlob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Clob createClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public NClob createNClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S4Connection)this.m_connection).getClientInfo();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((S4Connection)this.m_connection).getClientInfo(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return !super.isClosed() && this.m_connection.getDSIConnection().isAlive();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n, n2);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n, n2, n3);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, nArray);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, stringArray);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S4Connection)this.m_connection).setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLClientInfoException);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S4Connection)this.m_connection).setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLClientInfoException);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }
}

