/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.VStream;
import com.vertica.localization.VMessageKey;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.RecoverableException;
import java.io.IOException;

public class RowData {
    private VStream m_vStream;
    private byte[][] cols;
    private int rowlength;
    private int columnCount;
    private int curReadIdx;

    RowData(VStream vStream) throws IOException {
        this.m_vStream = vStream;
        this.cols = null;
        this.rowlength = 0;
        this.columnCount = this.m_vStream.ReceiveIntegerR(2);
        this.curReadIdx = -1;
        if (this.columnCount > 0) {
            this.cols = new byte[this.columnCount][];
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isReadDone() {
        return this.curReadIdx == this.columnCount - 1;
    }

    public byte[] getColumnAt(int n) throws RecoverableException {
        assert (n < this.columnCount);
        while (this.curReadIdx < n) {
            this.readNextColumn();
        }
        return this.cols[n];
    }

    public void setColumnAt(int n, byte[] byArray) {
        assert (n <= this.curReadIdx);
        this.cols[n] = byArray;
    }

    public int getRowLength() {
        assert (this.isReadDone());
        return this.rowlength;
    }

    void readAll() throws RecoverableException {
        while (this.curReadIdx < this.columnCount - 1) {
            this.readNextColumn();
        }
    }

    private void readNextColumn() throws RecoverableException {
        try {
            int n = this.m_vStream.ReceiveIntegerR(4);
            byte[] byArray = null;
            if (n >= 0) {
                byArray = new byte[n];
                this.m_vStream.Receive(byArray, 0, n);
                this.rowlength += n;
            } else {
                ++this.rowlength;
            }
            this.cols[++this.curReadIdx] = byArray;
        }
        catch (IOException iOException) {
            throw new RecoverableException(DiagState.DIAG_COMM_LINK_FAILURE, 101, VMessageKey.NETWORK_ERROR_GENERAL.toString(), new String[]{iOException.toString()}, (Throwable)iOException);
        }
    }
}

