/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.exceptions.jdbc3;

import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.dsi.exceptions.InvalidArgumentException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.AbstractDriver;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.FailedPropertiesReason;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBC3ExceptionConverter
extends ExceptionConverter {
    @Override
    public SQLException toSQLException(Exception exception, IWarningListener iWarningListener) {
        if (exception instanceof SQLException) {
            return (SQLException)exception;
        }
        IMessageSource iMessageSource = iWarningListener.getMessageSource();
        SQLException sQLException = null;
        if (exception instanceof NullPointerException) {
            String string = iMessageSource.loadMessage(iWarningListener.getLocale(), 1, JDBCMessageKey.NULL_ERROR.name());
            sQLException = new SQLException(string, JDBCMessageKey.NULL_ERROR.getSQLState(), 0);
        } else if (exception instanceof InputOutputException) {
            InputOutputException inputOutputException = (InputOutputException)exception;
            inputOutputException.loadMessage(iWarningListener.getMessageSource(), iWarningListener.getLocale());
            sQLException = new SQLException(inputOutputException.getMessage(), "HY000", inputOutputException.getErrorCode());
        } else if (exception instanceof InvalidArgumentException) {
            InvalidArgumentException invalidArgumentException = (InvalidArgumentException)exception;
            invalidArgumentException.loadMessage(iWarningListener.getMessageSource(), iWarningListener.getLocale());
            sQLException = new SQLException(invalidArgumentException.getMessage(), "HY000", invalidArgumentException.getErrorCode());
        } else if (exception instanceof ErrorException) {
            ErrorException errorException = (ErrorException)exception;
            int n = errorException.getNativeErrorCode(iMessageSource, iWarningListener.getLocale());
            String string = errorException.hasCustomState() ? errorException.getCustomState() : errorException.getDiagState().getSqlState();
            sQLException = new SQLException(errorException.getMessage(), string, n);
        } else {
            sQLException = new SQLException(AbstractDriver.getErrorMessageComponentName() + exception.getLocalizedMessage(), "HY000", 0);
        }
        sQLException.initCause(exception);
        sQLException.setStackTrace(exception.getStackTrace());
        return sQLException;
    }

    @Override
    protected SQLException createSQLException(String string, String string2, int n, StackTraceElement[] stackTraceElementArray, ExceptionType exceptionType, Map<String, FailedPropertiesReason> map) {
        SQLException sQLException = new SQLException(string2, string, n);
        sQLException.setStackTrace(stackTraceElementArray);
        return sQLException;
    }
}

