/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;

public class InvalidateJob
extends DataSourceJob {
    private static final Log log = Log.getLog(InvalidateJob.class);
    private long timeSpent;
    private List<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();

    public InvalidateJob(DBPDataSource dataSource) {
        super("Invalidate " + dataSource.getContainer().getName(), dataSource.getDefaultContext(false));
    }

    public List<ContextInvalidateResult> getInvalidateResults() {
        return this.invalidateResults;
    }

    public long getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        DBPDataSource dataSource = this.getExecutionContext().getDataSource();
        this.invalidateResults = InvalidateJob.invalidateDataSource(monitor, dataSource, false);
        return Status.OK_STATUS;
    }

    public static List<ContextInvalidateResult> invalidateDataSource(DBRProgressMonitor monitor, DBPDataSource dataSource, boolean disconnectOnFailure) {
        int n;
        ArrayList<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();
        DBPDataSourceContainer container = dataSource.getContainer();
        DBWNetworkHandler[] activeHandlers = container.getActiveNetworkHandlers();
        boolean networkOK = true;
        int goodContextsNumber = 0;
        if (activeHandlers != null && activeHandlers.length > 0) {
            DBWNetworkHandler[] dBWNetworkHandlerArray = activeHandlers;
            n = activeHandlers.length;
            int n2 = 0;
            while (n2 < n) {
                DBWNetworkHandler nh = dBWNetworkHandlerArray[n2];
                monitor.subTask("Invalidate network [" + container.getName() + "]");
                try {
                    nh.invalidateHandler(monitor, dataSource);
                }
                catch (Exception e) {
                    invalidateResults.add(new ContextInvalidateResult(DBCExecutionContext.InvalidateResult.ERROR, e));
                    networkOK = false;
                    break;
                }
                ++n2;
            }
        }
        if (networkOK) {
            DBCExecutionContext[] allContexts;
            monitor.subTask("Invalidate connections of [" + container.getName() + "]");
            DBCExecutionContext[] dBCExecutionContextArray = allContexts = dataSource.getAllContexts();
            int n3 = allContexts.length;
            n = 0;
            while (n < n3) {
                block19: {
                    DBCExecutionContext context = dBCExecutionContextArray[n];
                    long startTime = System.currentTimeMillis();
                    try {
                        try {
                            DBCExecutionContext.InvalidateResult result = context.invalidateContext(monitor, disconnectOnFailure);
                            if (result != DBCExecutionContext.InvalidateResult.ERROR) {
                                ++goodContextsNumber;
                            }
                            invalidateResults.add(new ContextInvalidateResult(result, null));
                        }
                        catch (Exception e) {
                            invalidateResults.add(new ContextInvalidateResult(DBCExecutionContext.InvalidateResult.ERROR, e));
                            System.currentTimeMillis();
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        System.currentTimeMillis();
                        throw throwable;
                    }
                    System.currentTimeMillis();
                }
                ++n;
            }
        }
        if (goodContextsNumber == 0 && disconnectOnFailure) {
            try {
                container.disconnect(monitor);
            }
            catch (Exception e) {
                log.error("Error closing unaccessible datasource", e);
            }
            StringBuilder msg = new StringBuilder();
            for (ContextInvalidateResult result : invalidateResults) {
                if (result.error == null) continue;
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append(result.error.getMessage());
            }
            DBUserInterface.getInstance().showError("Forced disconnect", "Datasource '" + container.getName() + "' was disconnected: destination database unreachable.\n" + msg);
        }
        if (goodContextsNumber == 0) {
            DBeaverNotifications.showNotification(dataSource, "reconnect", "Datasource invalidate failed", DBPMessageType.ERROR);
        } else {
            DBeaverNotifications.showNotification(dataSource, "reconnect", "Datasource was invalidated\n\nLive connection count: " + goodContextsNumber + "/" + dataSource.getAllContexts().length, DBPMessageType.INFORMATION);
        }
        return invalidateResults;
    }

    @Override
    protected void canceling() {
        this.getThread().interrupt();
    }

    public static class ContextInvalidateResult {
        public final DBCExecutionContext.InvalidateResult result;
        public final Exception error;

        ContextInvalidateResult(DBCExecutionContext.InvalidateResult result, Exception error) {
            this.result = result;
            this.error = error;
        }

        public String toString() {
            return this.result.name();
        }
    }
}

