/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DisconnectJob
extends AbstractJob {
    private IStatus connectStatus;
    protected final DBPDataSourceContainer container;

    public DisconnectJob(DBPDataSourceContainer container) {
        super("Disconnect from '" + container.getName() + "'");
        this.setUser(true);
        this.container = container;
    }

    public IStatus getConnectStatus() {
        return this.connectStatus;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        try {
            this.container.disconnect(monitor);
            this.connectStatus = Status.OK_STATUS;
        }
        catch (Throwable ex) {
            this.connectStatus = GeneralUtils.makeExceptionStatus(ex);
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return this.container == family;
    }

    @Override
    protected void canceling() {
        this.getThread().interrupt();
    }
}

