/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class SQLSemanticProcessor {
    private static final Log log = Log.getLog(SQLSemanticProcessor.class);
    private static final String NESTED_QUERY_AlIAS = "z_q";

    public static boolean isSelectQuery(String query) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)query);
            return statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect && CommonUtils.isEmpty((Collection)((PlainSelect)((Select)statement).getSelectBody()).getIntoTables());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String addFiltersToQuery(DBPDataSource dataSource, String sqlQuery, DBDDataFilter dataFilter) {
        if (dataSource instanceof SQLDataSource) {
            ((SQLDataSource)dataSource).getSQLDialect().supportsSubqueries();
        }
        if (!dataSource.getContainer().getPreferenceStore().getBoolean("sql.query.filter.force.subselect")) {
            try {
                PlainSelect select;
                Statement statement = CCJSqlParserUtil.parse((String)sqlQuery);
                if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect && SQLSemanticProcessor.patchSelectQuery(dataSource, select = (PlainSelect)((Select)statement).getSelectBody(), dataFilter)) {
                    return statement.toString();
                }
            }
            catch (Throwable e) {
                log.debug("SQL parse error", e);
            }
        }
        return SQLSemanticProcessor.wrapQuery(dataSource, sqlQuery, dataFilter);
    }

    public static String wrapQuery(DBPDataSource dataSource, String sqlQuery, DBDDataFilter dataFilter) {
        StringBuilder modifiedQuery = new StringBuilder(sqlQuery.length() + 100);
        modifiedQuery.append("SELECT * FROM (\n");
        modifiedQuery.append(sqlQuery);
        modifiedQuery.append("\n) ").append(NESTED_QUERY_AlIAS);
        if (dataFilter.hasConditions()) {
            modifiedQuery.append(" WHERE ");
            SQLUtils.appendConditionString(dataFilter, dataSource, NESTED_QUERY_AlIAS, modifiedQuery, true);
        }
        if (dataFilter.hasOrdering()) {
            modifiedQuery.append(" ORDER BY ");
            SQLUtils.appendOrderString(dataFilter, dataSource, NESTED_QUERY_AlIAS, modifiedQuery);
        }
        return modifiedQuery.toString();
    }

    private static boolean patchSelectQuery(DBPDataSource dataSource, PlainSelect select, DBDDataFilter filter) throws JSQLParserException {
        if (filter.hasConditions()) {
            for (DBDAttributeConstraint co : filter.getConstraints()) {
                if (!co.hasCondition()) continue;
                Table table = SQLSemanticProcessor.getConstraintTable(select, co);
                if (table != null) {
                    if (table.getAlias() != null) {
                        co.setEntityAlias(table.getAlias().getName());
                        continue;
                    }
                    co.setEntityAlias(table.getName());
                    continue;
                }
                co.setEntityAlias(null);
            }
            StringBuilder whereString = new StringBuilder();
            SQLUtils.appendConditionString(filter, dataSource, null, whereString, true);
            String condString = whereString.toString();
            SQLSemanticProcessor.addWhereToSelect(select, condString);
        }
        if (filter.hasOrdering()) {
            ArrayList<OrderByElement> orderByElements = select.getOrderByElements();
            if (orderByElements == null) {
                orderByElements = new ArrayList<OrderByElement>();
                select.setOrderByElements(orderByElements);
            }
            for (DBDAttributeConstraint co : filter.getOrderConstraints()) {
                Expression orderExpr = SQLSemanticProcessor.getConstraintExpression(dataSource, select, co);
                OrderByElement element = new OrderByElement();
                element.setExpression(orderExpr);
                if (co.isOrderDescending()) {
                    element.setAsc(false);
                    element.setAscDescPresent(true);
                }
                orderByElements.add(element);
            }
        }
        return true;
    }

    private static Expression getConstraintExpression(DBPDataSource dataSource, PlainSelect select, DBDAttributeConstraint co) throws JSQLParserException {
        Expression orderExpr;
        String attrName = DBUtils.getQuotedIdentifier(dataSource, co.getAttribute().getName());
        if (attrName.isEmpty()) {
            orderExpr = new LongValue((long)(co.getAttribute().getOrdinalPosition() + 1));
        } else if (CommonUtils.isJavaIdentifier((CharSequence)attrName)) {
            Table orderTable = CommonUtils.isEmpty((Collection)select.getJoins()) ? null : SQLSemanticProcessor.getConstraintTable(select, co);
            orderExpr = new Column(orderTable, attrName);
        } else {
            orderExpr = CCJSqlParserUtil.parseExpression((String)attrName);
        }
        return orderExpr;
    }

    @Nullable
    public static Table getConstraintTable(PlainSelect select, DBDAttributeConstraint constraint) {
        String constrTable;
        DBSAttributeBase ca = constraint.getAttribute();
        if (ca instanceof DBDAttributeBinding) {
            constrTable = ((DBDAttributeBinding)ca).getMetaAttribute().getEntityName();
        } else if (ca instanceof DBSEntityAttribute) {
            constrTable = ((DBSEntityAttribute)ca).getParentObject().getName();
        } else {
            return null;
        }
        if (constrTable == null) {
            return null;
        }
        FromItem fromItem = select.getFromItem();
        Table table = SQLSemanticProcessor.findTableInFrom(fromItem, constrTable);
        if (table == null && !CommonUtils.isEmpty((Collection)select.getJoins())) {
            for (Join join : select.getJoins()) {
                table = SQLSemanticProcessor.findTableInFrom(join.getRightItem(), constrTable);
                if (table != null) break;
            }
        }
        return table;
    }

    @Nullable
    private static Table findTableInFrom(FromItem fromItem, String tableName) {
        if (fromItem instanceof Table && tableName.equals(((Table)fromItem).getName())) {
            return (Table)fromItem;
        }
        return null;
    }

    public static void addWhereToSelect(PlainSelect select, String condString) throws JSQLParserException {
        Expression filterWhere;
        try {
            filterWhere = CCJSqlParserUtil.parseCondExpression((String)condString);
        }
        catch (JSQLParserException e) {
            throw new JSQLParserException("Bad query condition: [" + condString + "]", (Throwable)e);
        }
        SQLSemanticProcessor.addWhereToSelect(select, filterWhere);
    }

    public static void addWhereToSelect(PlainSelect select, Expression conditionExpr) throws JSQLParserException {
        Expression sourceWhere = select.getWhere();
        if (sourceWhere == null) {
            select.setWhere(conditionExpr);
        } else {
            select.setWhere((Expression)new AndExpression((Expression)new Parenthesis(sourceWhere), conditionExpr));
        }
    }
}

