/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DefaultProgressMonitor
implements DBRProgressMonitor {
    private static final Log log = Log.getLog(DefaultProgressMonitor.class);
    private IProgressMonitor nestedMonitor;
    private List<DBRBlockingObject> blocks = null;

    public DefaultProgressMonitor(IProgressMonitor nestedMonitor) {
        this.nestedMonitor = nestedMonitor;
    }

    @Override
    public IProgressMonitor getNestedMonitor() {
        return this.nestedMonitor;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.nestedMonitor.beginTask(name, totalWork);
    }

    @Override
    public void done() {
        this.nestedMonitor.done();
    }

    @Override
    public void subTask(String name) {
        this.nestedMonitor.subTask(name);
    }

    @Override
    public void worked(int work) {
        this.nestedMonitor.worked(work);
    }

    @Override
    public boolean isCanceled() {
        return this.nestedMonitor.isCanceled();
    }

    @Override
    public synchronized void startBlock(DBRBlockingObject object, String taskName) {
        if (taskName != null) {
            this.subTask(taskName);
        }
        if (this.blocks == null) {
            this.blocks = new ArrayList<DBRBlockingObject>();
        }
        this.blocks.add(object);
    }

    @Override
    public synchronized void endBlock() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            log.warn("End block invoked while no blocking objects are in stack");
            return;
        }
        this.blocks.remove(this.blocks.size() - 1);
    }

    @Override
    public synchronized DBRBlockingObject getActiveBlock() {
        return this.blocks == null || this.blocks.isEmpty() ? null : this.blocks.get(this.blocks.size() - 1);
    }
}

