/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.edit.prop.DBECommandDeleteObject;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyReflector;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyValidator;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.ProxyPropertyDescriptor;
import org.jkiss.dbeaver.model.impl.edit.AbstractObjectManager;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class SQLObjectEditor<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBSObject>
extends AbstractObjectManager<OBJECT_TYPE>
implements DBEObjectEditor<OBJECT_TYPE>,
DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> {
    public static final String PATTERN_ITEM_INDEX = "%INDEX%";
    public static final String PATTERN_ITEM_TABLE = "%TABLE%";
    public static final String PATTERN_ITEM_INDEX_SHORT = "%INDEX_SHORT%";
    public static final String PATTERN_ITEM_CONSTRAINT = "%CONSTRAINT%";

    @Override
    public boolean canEditObject(OBJECT_TYPE object) {
        return true;
    }

    @Override
    public final DBEPropertyHandler<OBJECT_TYPE> makePropertyHandler(OBJECT_TYPE object, DBPPropertyDescriptor property) {
        return new PropertyHandler(property);
    }

    @Override
    public boolean canCreateObject(CONTAINER_TYPE parent) {
        return true;
    }

    @Override
    public boolean canDeleteObject(OBJECT_TYPE object) {
        return true;
    }

    @Override
    public final OBJECT_TYPE createNewObject(DBRProgressMonitor monitor, DBECommandContext commandContext, CONTAINER_TYPE parent, Object copyFrom) throws DBException {
        OBJECT_TYPE newObject;
        try {
            newObject = this.createDatabaseObject(monitor, commandContext, parent, copyFrom);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Can't create object here.\nWrong container type: " + parent.getClass().getSimpleName());
        }
        if (newObject == null) {
            return null;
        }
        ObjectCreateCommand createCommand = this.makeCreateCommand(newObject);
        commandContext.getUserParams().put(newObject, createCommand);
        commandContext.addCommand(createCommand, new AbstractObjectManager.CreateObjectReflector(this), true);
        this.createObjectReferences(monitor, commandContext, createCommand);
        return newObject;
    }

    protected void createObjectReferences(DBRProgressMonitor monitor, DBECommandContext commandContext, ObjectCreateCommand createCommand) throws DBException {
    }

    @Override
    public void deleteObject(DBECommandContext commandContext, OBJECT_TYPE object, Map<String, Object> options) throws DBException {
        commandContext.addCommand(new ObjectDeleteCommand(this, object, ModelMessages.model_jdbc_delete_object), new AbstractObjectManager.DeleteObjectReflector(this), true);
    }

    public ObjectCreateCommand makeCreateCommand(OBJECT_TYPE object) {
        return new ObjectCreateCommand(this, object, ModelMessages.model_jdbc_create_new_object);
    }

    protected abstract OBJECT_TYPE createDatabaseObject(DBRProgressMonitor var1, DBECommandContext var2, CONTAINER_TYPE var3, Object var4) throws DBException;

    protected abstract void addObjectCreateActions(List<DBEPersistAction> var1, ObjectCreateCommand var2, Map<String, Object> var3);

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, ObjectChangeCommand command, Map<String, Object> options) {
    }

    protected void addObjectExtraActions(List<DBEPersistAction> actions, NestedObjectCommand<OBJECT_TYPE, PropertyHandler> command, Map<String, Object> options) {
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, ObjectRenameCommand command, Map<String, Object> options) {
        throw new IllegalStateException("Object rename is not supported in " + this.getClass().getSimpleName());
    }

    protected void addObjectReorderActions(List<DBEPersistAction> actions, ObjectReorderCommand command, Map<String, Object> options) {
        if (((DBSObject)command.getObject()).isPersisted()) {
            throw new IllegalStateException("Object reorder is not supported in " + this.getClass().getSimpleName());
        }
    }

    protected abstract void addObjectDeleteActions(List<DBEPersistAction> var1, ObjectDeleteCommand var2, Map<String, Object> var3);

    protected StringBuilder getNestedDeclaration(CONTAINER_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        return null;
    }

    protected void validateObjectProperty(OBJECT_TYPE object, DBPPropertyDescriptor property, Object value) throws DBException {
    }

    protected void validateObjectProperties(ObjectChangeCommand command) throws DBException {
    }

    protected void processObjectRename(DBECommandContext commandContext, OBJECT_TYPE object, String newName) throws DBException {
        ObjectRenameCommand command = new ObjectRenameCommand(this, object, ModelMessages.model_jdbc_rename_object, newName);
        commandContext.addCommand(command, new RenameObjectReflector(), true);
    }

    protected void processObjectReorder(DBECommandContext commandContext, OBJECT_TYPE object, List<? extends DBPOrderedObject> siblings, int newPosition) throws DBException {
        ObjectReorderCommand command = new ObjectReorderCommand(this, object, siblings, ModelMessages.model_jdbc_reorder_object, newPosition);
        commandContext.addCommand(command, new ReorderObjectReflector(), true);
    }

    protected static class EmptyCommand
    extends DBECommandAbstract<DBPObject> {
        public EmptyCommand(DBPObject object) {
            super(object, "Empty");
        }
    }

    protected static abstract class NestedObjectCommand<OBJECT_TYPE extends DBSObject, HANDLER_TYPE extends DBEPropertyHandler<OBJECT_TYPE>>
    extends DBECommandComposite<OBJECT_TYPE, HANDLER_TYPE> {
        protected NestedObjectCommand(OBJECT_TYPE object, String title) {
            super(object, title);
        }

        public abstract String getNestedDeclaration(DBSObject var1, Map<String, Object> var2);
    }

    protected static class ObjectChangeCommand
    extends NestedObjectCommand<OBJECT_TYPE, PropertyHandler> {
        final /* synthetic */ SQLObjectEditor this$0;

        public ObjectChangeCommand(OBJECT_TYPE object) {
            this.this$0 = var1_1;
            super(object, "JDBC Composite");
        }

        @Override
        public DBEPersistAction[] getPersistActions(Map<String, Object> options) {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addObjectModifyActions(actions, this, options);
            this.this$0.addObjectExtraActions(actions, this, options);
            return actions.toArray(new DBEPersistAction[actions.size()]);
        }

        @Override
        public void validateCommand() throws DBException {
            this.this$0.validateObjectProperties(this);
        }

        @Override
        public String getNestedDeclaration(DBSObject owner, Map<String, Object> options) {
            StringBuilder decl = this.this$0.getNestedDeclaration(owner, this, options);
            return CommonUtils.isEmpty((CharSequence)decl) ? null : decl.toString();
        }
    }

    protected static class ObjectCreateCommand
    extends NestedObjectCommand<OBJECT_TYPE, PropertyHandler> {
        final /* synthetic */ SQLObjectEditor this$0;

        protected ObjectCreateCommand(OBJECT_TYPE object, String title) {
            this.this$0 = var1_1;
            super(object, title);
        }

        @Override
        public DBEPersistAction[] getPersistActions(Map<String, Object> options) {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addObjectCreateActions(actions, this, options);
            this.this$0.addObjectExtraActions(actions, this, options);
            return actions.toArray(new DBEPersistAction[actions.size()]);
        }

        @Override
        public void updateModel() {
            super.updateModel();
            DBSObject object = (DBSObject)this.getObject();
            if (!object.isPersisted()) {
                if (object instanceof DBPSaveableObject) {
                    ((DBPSaveableObject)((Object)object)).setPersisted(true);
                }
                DBUtils.fireObjectUpdate(object);
            }
        }

        @Override
        public String getNestedDeclaration(DBSObject owner, Map<String, Object> options) {
            StringBuilder decl = this.this$0.getNestedDeclaration(owner, this, options);
            return CommonUtils.isEmpty((CharSequence)decl) ? null : decl.toString();
        }
    }

    protected static class ObjectDeleteCommand
    extends DBECommandDeleteObject<OBJECT_TYPE> {
        final /* synthetic */ SQLObjectEditor this$0;

        public ObjectDeleteCommand(OBJECT_TYPE table, String title) {
            this.this$0 = var1_1;
            super(table, title);
        }

        @Override
        public DBEPersistAction[] getPersistActions(Map<String, Object> options) {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addObjectDeleteActions(actions, this, options);
            return actions.toArray(new DBEPersistAction[actions.size()]);
        }

        @Override
        public void updateModel() {
            DBSObject object = (DBSObject)this.getObject();
            DBSObjectCache<DBSObject, DBSObject> cache = this.this$0.getObjectsCache(object);
            if (cache != null) {
                cache.removeObject(object, false);
            }
        }
    }

    protected static class ObjectRenameCommand
    extends DBECommandAbstract<OBJECT_TYPE> {
        private String oldName;
        private String newName;
        final /* synthetic */ SQLObjectEditor this$0;

        public ObjectRenameCommand(OBJECT_TYPE object, String title, String newName) {
            this.this$0 = var1_1;
            super(object, title);
            this.oldName = object.getName();
            this.newName = newName;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        @Override
        public DBEPersistAction[] getPersistActions(Map<String, Object> options) {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addObjectRenameActions(actions, this, options);
            return actions.toArray(new DBEPersistAction[actions.size()]);
        }

        @Override
        public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
            String mergeId = "rename" + ((DBSObject)this.getObject()).hashCode();
            ObjectRenameCommand renameCmd = (ObjectRenameCommand)userParams.get(mergeId);
            if (renameCmd != null) {
                renameCmd.newName = this.newName;
                return renameCmd;
            }
            renameCmd = new ObjectRenameCommand(this.this$0, (DBSObject)this.getObject(), this.getTitle(), this.newName);
            userParams.put(mergeId, renameCmd);
            return super.merge(prevCommand, userParams);
        }
    }

    protected class ObjectReorderCommand
    extends DBECommandAbstract<OBJECT_TYPE> {
        private List<? extends DBPOrderedObject> siblings;
        private int oldPosition;
        private int newPosition;
        final /* synthetic */ SQLObjectEditor this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ObjectReorderCommand(OBJECT_TYPE object, List<? extends DBPOrderedObject> siblings, String title, int newPosition) {
            this.this$0 = (SQLObjectEditor)n;
            super(object, title);
            this.siblings = siblings;
            this.oldPosition = ((DBPOrderedObject)object).getOrdinalPosition();
            this.newPosition = newPosition;
        }

        public List<? extends DBPOrderedObject> getSiblings() {
            return this.siblings;
        }

        public int getOldPosition() {
            return this.oldPosition;
        }

        public int getNewPosition() {
            return this.newPosition;
        }

        @Override
        public DBEPersistAction[] getPersistActions(Map<String, Object> options) {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addObjectReorderActions(actions, this, options);
            return actions.toArray(new DBEPersistAction[actions.size()]);
        }

        @Override
        public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
            String mergeId = "reorder" + ((DBSObject)this.getObject()).hashCode();
            ObjectReorderCommand reorderCmd = (ObjectReorderCommand)userParams.get(mergeId);
            if (reorderCmd != null) {
                reorderCmd.newPosition = this.newPosition;
                return reorderCmd;
            }
            reorderCmd = new ObjectReorderCommand(this.this$0, (DBSObject)this.getObject(), this.siblings, this.getTitle(), this.newPosition);
            userParams.put(mergeId, reorderCmd);
            return super.merge(prevCommand, userParams);
        }
    }

    protected class PropertyHandler
    extends ProxyPropertyDescriptor
    implements DBEPropertyHandler<OBJECT_TYPE>,
    DBEPropertyReflector<OBJECT_TYPE>,
    DBEPropertyValidator<OBJECT_TYPE> {
        private PropertyHandler(DBPPropertyDescriptor property) {
            super(property);
        }

        @Override
        public DBECommandComposite<OBJECT_TYPE, ? extends DBEPropertyHandler<OBJECT_TYPE>> createCompositeCommand(OBJECT_TYPE object) {
            return new ObjectChangeCommand(SQLObjectEditor.this, object);
        }

        @Override
        public void reflectValueChange(OBJECT_TYPE object, Object oldValue, Object newValue) {
        }

        public String toString() {
            return this.original.getDisplayName();
        }

        public int hashCode() {
            return this.original.getId().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == PropertyHandler.class && this.getId().equals(((PropertyHandler)obj).getId());
        }

        @Override
        public void validate(OBJECT_TYPE object, Object value) throws DBException {
            SQLObjectEditor.this.validateObjectProperty(object, this.original, value);
        }
    }

    public static class RefreshObjectReflector<OBJECT_TYPE extends DBSObject>
    implements DBECommandReflector<OBJECT_TYPE, DBECommandAbstract<OBJECT_TYPE>> {
        @Override
        public void redoCommand(DBECommandAbstract<OBJECT_TYPE> command) {
            DBUtils.fireObjectRefresh((DBSObject)command.getObject());
        }

        @Override
        public void undoCommand(DBECommandAbstract<OBJECT_TYPE> command) {
            DBUtils.fireObjectUpdate((DBSObject)command.getObject(), true);
        }
    }

    public class RenameObjectReflector
    implements DBECommandReflector<OBJECT_TYPE, ObjectRenameCommand> {
        @Override
        public void redoCommand(ObjectRenameCommand command) {
            if (command.getObject() instanceof DBPNamedObject2) {
                ((DBPNamedObject2)command.getObject()).setName(command.newName);
                DBUtils.fireObjectUpdate((DBSObject)command.getObject());
            }
        }

        @Override
        public void undoCommand(ObjectRenameCommand command) {
            if (command.getObject() instanceof DBPNamedObject2) {
                ((DBPNamedObject2)command.getObject()).setName(command.oldName);
                DBUtils.fireObjectUpdate((DBSObject)command.getObject());
            }
        }
    }

    public class ReorderObjectReflector
    implements DBECommandReflector<OBJECT_TYPE, ObjectReorderCommand> {
        @Override
        public void redoCommand(ObjectReorderCommand command) {
            DBSObject object = (DBSObject)command.getObject();
            for (DBPOrderedObject dBPOrderedObject : command.getSiblings()) {
                if (dBPOrderedObject == object) continue;
                int siblingPosition = dBPOrderedObject.getOrdinalPosition();
                if (command.newPosition < command.oldPosition) {
                    if (siblingPosition < command.newPosition || siblingPosition >= command.oldPosition) continue;
                    dBPOrderedObject.setOrdinalPosition(siblingPosition + 1);
                    continue;
                }
                if (siblingPosition > command.newPosition || siblingPosition <= command.oldPosition) continue;
                dBPOrderedObject.setOrdinalPosition(siblingPosition - 1);
            }
            ((DBPOrderedObject)((Object)object)).setOrdinalPosition(command.newPosition);
            DBSObject dBSObject = object.getParentObject();
            if (dBSObject != null) {
                DBUtils.fireObjectUpdate(dBSObject, DBPEvent.REORDER);
            }
        }

        @Override
        public void undoCommand(ObjectReorderCommand command) {
            ((DBPOrderedObject)command.getObject()).setOrdinalPosition(command.oldPosition);
            DBSObject parentObject = ((DBSObject)command.getObject()).getParentObject();
            if (parentObject != null) {
                DBUtils.fireObjectUpdate(parentObject, DBPEvent.REORDER);
            }
        }
    }
}

