/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class JDBCObjectCache<OWNER extends DBSObject, OBJECT extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT> {
    public static final int DEFAULT_MAX_CACHE_SIZE = 1000000;
    private static final Log log = Log.getLog(JDBCObjectCache.class);
    private int maximumCacheSize = 1000000;

    protected JDBCObjectCache() {
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull JDBCResultSet var3) throws SQLException, DBException;

    @Override
    @NotNull
    public Collection<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        if (!this.isFullyCached()) {
            this.loadObjects(monitor, owner);
        }
        return this.getCachedObjects();
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        if (!this.isFullyCached()) {
            this.loadObjects(monitor, owner);
        }
        return this.getCachedObject(name);
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, OWNER owner) throws DBException {
        Comparator comparator;
        ArrayList tmpObjectList;
        block31: {
            if (this.isFullyCached() || monitor.isCanceled()) {
                return;
            }
            tmpObjectList = new ArrayList();
            DBPDataSource dataSource = owner.getDataSource();
            if (dataSource == null) {
                throw new DBException("Not connected to database");
            }
            try {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession(monitor, dataSource, "Load objects from " + owner.getName());){
                        Throwable throwable2 = null;
                        Object var9_14 = null;
                        try (JDBCStatement dbStat = this.prepareObjectsStatement(session, owner);){
                            monitor.subTask("Load " + this.getCacheName());
                            dbStat.setFetchSize(1000);
                            dbStat.executeStatement();
                            JDBCResultSet dbResult = dbStat.getResultSet();
                            if (dbResult == null) break block31;
                            try {
                                while (dbResult.next()) {
                                    if (monitor.isCanceled()) {
                                    } else {
                                        OBJECT object = this.fetchObject(session, owner, dbResult);
                                        if (object == null) continue;
                                        tmpObjectList.add(object);
                                        if (tmpObjectList.size() != this.maximumCacheSize) continue;
                                        log.warn("Maximum cache size exceeded (" + this.maximumCacheSize + ") in " + this);
                                    }
                                    break;
                                }
                            }
                            finally {
                                dbResult.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException ex) {
                    throw new DBException(ex, dataSource);
                }
            }
            catch (DBException e) {
                if (this.handleCacheReadError(e)) break block31;
                throw e;
            }
        }
        if ((comparator = this.getListOrderComparator()) != null) {
            tmpObjectList.sort(comparator);
        }
        this.detectCaseSensitivity((DBSObject)owner);
        this.mergeCache(tmpObjectList);
        this.invalidateObjects(monitor, owner, new AbstractObjectCache.CacheIterator(this));
    }

    protected String getCacheName() {
        return this.getClass().getSimpleName();
    }

    protected boolean handleCacheReadError(DBException error) {
        return false;
    }
}

