/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;

public class Log {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final ILog eclipseLog = ModelActivator.getInstance().getLog();
    private static Listener[] listeners = new Listener[0];
    private final String name;

    public static ILog getEclipseLog() {
        return eclipseLog;
    }

    public static Log getLog(Class<?> forClass) {
        return new Log(forClass.getName());
    }

    public void log(IStatus status) {
        if (status == null) {
            return;
        }
        int severity = status.getSeverity();
        String message = status.getMessage();
        Throwable exception = status.getException();
        switch (severity) {
            case 8: {
                this.debug(message, exception);
                break;
            }
            case 4: {
                this.error(message, exception);
                break;
            }
            case 2: {
                this.warn(message, exception);
                break;
            }
            case 1: {
                this.info(message, exception);
                break;
            }
            case 0: {
                this.trace(message, exception);
                break;
            }
        }
    }

    private Log(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(Object message) {
    }

    public void trace(Object message, Throwable t) {
    }

    public void debug(Object message) {
        if (message instanceof Throwable) {
            this.debug(message.toString(), (Throwable)message);
        } else {
            this.debug(message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        Log.debugMessage(message, t, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugMessage(Object message, Throwable t, PrintStream debugWriter) {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            debugWriter.print(String.valueOf(sdf.format(new Date())) + " - ");
            debugWriter.println(message);
            if (t != null) {
                t.printStackTrace(debugWriter);
            }
            debugWriter.flush();
            Listener[] listenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.loggedMessage(message, t);
                ++n2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void info(Object message) {
        if (message instanceof Throwable) {
            this.info(message.toString(), (Throwable)message);
            return;
        }
        Log.debugMessage(message, null, System.err);
        int severity = 1;
        Log.getEclipseLog().log((IStatus)Log.createStatus(severity, message));
    }

    public void info(Object message, Throwable t) {
        Log.writeExceptionStatus(1, message, t);
    }

    public void warn(Object message) {
        if (message instanceof Throwable) {
            this.warn(message.toString(), (Throwable)message);
            return;
        }
        Log.debugMessage(message, null, System.err);
        int severity = 2;
        Log.getEclipseLog().log((IStatus)Log.createStatus(severity, message));
    }

    public void warn(Object message, Throwable t) {
        Log.writeExceptionStatus(2, message, t);
    }

    public void error(Object message) {
        if (message instanceof Throwable) {
            this.error(null, (Throwable)message);
            return;
        }
        Log.debugMessage(message, null, System.err);
        int severity = 4;
        Log.getEclipseLog().log((IStatus)Log.createStatus(severity, message));
    }

    public void error(Object message, Throwable t) {
        Log.writeExceptionStatus(4, message, t);
    }

    public void fatal(Object message) {
        this.error(message);
    }

    public void fatal(Object message, Throwable t) {
        this.error(message, t);
    }

    private static void writeExceptionStatus(int severity, Object message, Throwable t) {
        Log.debugMessage(message, t, System.err);
        ILog log = Log.getEclipseLog();
        if (t == null) {
            log.log((IStatus)Log.createStatus(severity, message));
        } else if (message == null) {
            log.log(GeneralUtils.makeExceptionStatus(severity, t));
        } else {
            log.log(GeneralUtils.makeExceptionStatus(severity, message.toString(), t));
        }
    }

    private static Status createStatus(int severity, Object message) {
        return new Status(severity, "org.jkiss.dbeaver.model", message == null ? null : message.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(Listener listener) {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            listeners = (Listener[])ArrayUtils.add(Listener.class, (Object[])listeners, (Object)listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(Listener listener) {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            listeners = (Listener[])ArrayUtils.remove(Listener.class, (Object[])listeners, (Object)listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static interface Listener {
        public void loggedMessage(Object var1, Throwable var2);
    }
}

