/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.jkiss.dbeaver.data.gis.handlers.GeometryConverter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class GISGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final GISGeometryValueHandler INSTANCE = new GISGeometryValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, this.fetchBytes(resultSet, index), false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof byte[]) {
            this.bindBytes(statement, paramIndex, (byte[])value);
        } else if (value instanceof Geometry) {
            this.bindBytes(statement, paramIndex, GeometryConverter.getInstance().to((Geometry)value));
        }
    }

    public Class<?> getValueObjectType(DBSTypedObject attribute) {
        return Geometry.class;
    }

    public Object getValueFromObject(DBCSession session, DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Geometry) {
            return object;
        }
        if (object instanceof byte[]) {
            return GeometryConverter.getInstance().from((byte[])object);
        }
        if (object instanceof String) {
            return GeometryConverter.getInstance().from((String)object);
        }
        throw new DBCException("Unsupported geometry value: " + object);
    }

    protected byte[] fetchBytes(JDBCResultSet resultSet, int index) throws SQLException {
        return resultSet.getBytes(index);
    }

    protected void bindBytes(JDBCPreparedStatement dbStat, int index, byte[] bytes) throws SQLException {
        dbStat.setBytes(index, bytes);
    }
}

