/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.internal.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMProduct;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;

public class PublicServiceClient {
    private static final Log log = Log.getLog(PublicServiceClient.class);
    public static final String PUBLIC_SERVICE_HOST = "dbeaver.com";
    public static final String PUBLIC_SERVICE_URL = "https://dbeaver.com/lmp/";
    private final CloseableHttpClient httpclient;

    public PublicServiceClient() {
        this(0, 0);
    }

    public PublicServiceClient(int n, int n2) {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (n > 0) {
            builder.setConnectTimeout(n);
        }
        if (n2 > 0) {
            builder.setSocketTimeout(n2);
        }
        RequestConfig requestConfig = builder.build();
        String string = String.valueOf(CommonUtils.notEmpty((String)System.getProperty("os.name"))) + " " + CommonUtils.notEmpty((String)System.getProperty("os.arch"));
        this.httpclient = HttpClientBuilder.create().setUserAgent(String.valueOf(GeneralUtils.getProductTitle()) + " [" + string.trim() + "]").setDefaultRequestConfig(requestConfig).build();
    }

    private HttpGet makeGetRequest(String string) {
        HttpGet httpGet = new HttpGet(PUBLIC_SERVICE_URL + string);
        return httpGet;
    }

    private HttpPost makePostRequest(String string) {
        HttpPost httpPost = new HttpPost(PUBLIC_SERVICE_URL + string);
        return httpPost;
    }

    public String ping() throws LMException {
        try {
            HttpGet httpGet = this.makeGetRequest("ping");
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpResponse closeableHttpResponse = this.httpclient.execute((HttpUriRequest)httpGet);){
                return EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            throw new LMException("Ping failed", throwable);
        }
    }

    public String checkCustomerEmail(LMProduct lMProduct, String string) throws LMException {
        try {
            HttpGet httpGet = this.makeGetRequest("checkCustomer?product=" + lMProduct.getId() + "&version=" + lMProduct.getVersion() + "&email=" + string);
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseableHttpResponse closeableHttpResponse = this.httpclient.execute((HttpUriRequest)httpGet);){
                return EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            throw new LMException("Customer check failed", throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateTrialLicense(LMProduct lMProduct, String string, String string2, String string3, String string4) throws LMException {
        String string5 = this.generateLicenseRequest(lMProduct, string, string2, string3, string4);
        try {
            HttpPost httpPost = this.makePostRequest("generateTrialLicense");
            httpPost.setHeader("Content-Type", "text/xml");
            httpPost.setEntity((HttpEntity)new StringEntity(string5));
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                String string6;
                CloseableHttpResponse closeableHttpResponse = this.httpclient.execute((HttpUriRequest)httpPost);
                try {
                    int n = closeableHttpResponse.getStatusLine().getStatusCode();
                    if (n < 200) throw new LMException("Bad server status (" + n + "): " + closeableHttpResponse.getStatusLine().getReasonPhrase());
                    if (n >= 300) throw new LMException("Bad server status (" + n + "): " + closeableHttpResponse.getStatusLine().getReasonPhrase());
                    if (closeableHttpResponse.getEntity() == null) throw new LMException("Internal error - empty license has been returned");
                    if (closeableHttpResponse.getEntity().getContentLength() == 0L) {
                        throw new LMException("Internal error - empty license has been returned");
                    }
                    string6 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                    return string6;
                }
                finally {
                    if (closeableHttpResponse == null) return string6;
                    closeableHttpResponse.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            throw new LMException("Error generating trial license", throwable);
        }
    }

    public String checkLicenseStatus(LMLicense lMLicense) throws LMException {
        try {
            HttpGet httpGet = this.makeGetRequest("checkLicense?product=" + lMLicense.getProductId() + "&version=" + lMLicense.getProductVersion() + "&license=" + lMLicense.getLicenseId());
            Throwable throwable = null;
            Object var4_7 = null;
            try (CloseableHttpResponse closeableHttpResponse = this.httpclient.execute((HttpUriRequest)httpGet);){
                if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                    throw new IOException("Bad HTTP response: " + closeableHttpResponse.getStatusLine().getStatusCode());
                }
                return EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.debug((Object)("Error checking license " + lMLicense.getLicenseId() + " status: " + iOException.getMessage()));
            return null;
        }
        catch (Throwable throwable) {
            throw new LMException("License check failed", throwable);
        }
    }

    private String generateLicenseRequest(LMProduct lMProduct, String string, String string2, String string3, String string4) throws LMException {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLBuilder xMLBuilder = new XMLBuilder((Writer)stringWriter, "UTF-8");
            xMLBuilder.setButify(true);
            Throwable throwable = null;
            Object var9_11 = null;
            try (XMLBuilder.Element element = xMLBuilder.startElement("request");){
                xMLBuilder.addAttribute("license", "trial");
                xMLBuilder.addAttribute("productId", lMProduct.getId());
                xMLBuilder.addAttribute("productVersion", lMProduct.getVersion());
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (XMLBuilder.Element element2 = xMLBuilder.startElement("customer");){
                    xMLBuilder.addAttribute("email", string);
                    xMLBuilder.addAttribute("firstName", string2);
                    xMLBuilder.addAttribute("lastName", string3);
                    xMLBuilder.addAttribute("company", string4);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            xMLBuilder.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new LMException("IO errot generating license request", (Throwable)iOException);
        }
    }
}

