/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPNamedObject;

public abstract class PropertyAwarePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
DBPNamedObject {
    @NotNull
    public String getName() {
        return ((ERDObject)this.getModel()).getName();
    }

    protected boolean isEditEnabled() {
        return this.getParent() instanceof DiagramPart && ((DiagramPart)this.getParent()).getDiagram().isLayoutManualAllowed();
    }

    public void activate() {
        super.activate();
        ERDObject erdObject = (ERDObject)this.getModel();
        erdObject.addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ERDObject erdObject = (ERDObject)this.getModel();
        erdObject.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("CHILD".equals(property)) {
            this.handleChildChange(evt);
        }
        if ("REORDER".equals(property)) {
            this.handleReorderChange(evt);
        } else if ("OUTPUT".equals(property)) {
            this.handleOutputChange(evt);
        } else if ("INPUT".equals(property)) {
            this.handleInputChange(evt);
        } else if ("NAME".equals(property)) {
            this.commitNameChange(evt);
        }
        if ("NAME".equals(property)) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getViewer().getContents();
            IFigure partFigure = graphicalEditPart.getFigure();
            partFigure.getUpdateManager().performUpdate();
        }
    }

    private void handleInputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for INPUT event");
        }
        if (newValue != null) {
            ConnectionEditPart editPart = this.createOrFindConnection(newValue);
            int modelIndex = this.getModelTargetConnections().indexOf(newValue);
            this.addTargetConnection(editPart, modelIndex);
        } else {
            List children = this.getTargetConnections();
            ConnectionEditPart partToRemove = null;
            for (ConnectionEditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeTargetConnection(partToRemove);
            }
        }
        this.getContentPane().revalidate();
    }

    private void handleOutputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for INPUT event");
        }
        if (newValue != null) {
            ConnectionEditPart editPart = this.createOrFindConnection(newValue);
            int modelIndex = this.getModelSourceConnections().indexOf(newValue);
            this.addSourceConnection(editPart, modelIndex);
        } else {
            List children = this.getSourceConnections();
            ConnectionEditPart partToRemove = null;
            for (ConnectionEditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeSourceConnection(partToRemove);
            }
        }
        this.getContentPane().revalidate();
    }

    protected void handleChildChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for CHILD event");
        }
        if (newValue != null) {
            EditPart editPart = this.createChild(newValue);
            int modelIndex = this.getModelChildren().indexOf(newValue);
            this.addChild(editPart, modelIndex);
        } else {
            List children = this.getChildren();
            EditPart partToRemove = null;
            for (EditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeChild(partToRemove);
            }
        }
    }

    protected void handleReorderChange(PropertyChangeEvent evt) {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected void commitNameChange(PropertyChangeEvent evt) {
    }
}

