/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.jkiss.dbeaver.ext.erd.directedit.ExtendedDirectEditManager;
import org.jkiss.dbeaver.ext.erd.directedit.LabelCellEditorLocator;
import org.jkiss.dbeaver.ext.erd.directedit.TableNameCellEditorValidator;
import org.jkiss.dbeaver.ext.erd.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.ext.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.figures.EditableLabel;
import org.jkiss.dbeaver.ext.erd.figures.EntityFigure;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.AssociationPart;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.policy.EntityContainerEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.EntityEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.EntityNodeEditPolicy;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class EntityPart
extends NodePart {
    protected DirectEditManager manager;

    public ERDEntity getTable() {
        return (ERDEntity)this.getModel();
    }

    protected List<ERDEntityAttribute> getModelChildren() {
        return this.getTable().getColumns();
    }

    protected List<ERDAssociation> getModelSourceConnections() {
        return this.getTable().getForeignKeyRelationships();
    }

    protected List<ERDAssociation> getModelTargetConnections() {
        return this.getTable().getPrimaryKeyRelationships();
    }

    protected void createEditPolicies() {
        boolean editEnabled = this.isEditEnabled();
        if (editEnabled) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new EntityNodeEditPolicy());
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new EntityContainerEditPolicy());
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityEditPolicy());
        }
    }

    public void performRequest(Request request) {
        if (request.getType() != "direct edit" && request.getType() == "open") {
            this.getTable().openEditor();
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        EntityFigure figure = this.getFigure();
        EditableLabel nameLabel = figure.getNameLabel();
        nameLabel.translateToRelative((Translatable)requestLoc);
        return nameLabel.containsPoint(requestLoc);
    }

    protected void performDirectEdit() {
        if (this.manager == null) {
            ERDGraphicalViewer viewer = this.getViewer();
            ValidationMessageHandler handler = viewer.getValidationHandler();
            EntityFigure figure = this.getFigure();
            EditableLabel nameLabel = figure.getNameLabel();
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(nameLabel), nameLabel, new TableNameCellEditorValidator(handler));
        }
        this.manager.show();
    }

    public void handleNameChange(String value) {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        label.setVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        ERDEntity entity = this.getTable();
        label.setText(((DBSEntity)entity.getObject()).getName());
        label.setVisible(true);
        this.refreshVisuals();
    }

    public String toString() {
        return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)this.getTable().getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        label.setText(((DBSEntity)this.getTable().getObject()).getName());
        label.setVisible(true);
        this.refreshVisuals();
    }

    protected EntityFigure createFigure() {
        EntityDiagram diagram = ((DiagramPart)this.getParent()).getDiagram();
        boolean useFQN = diagram.hasAttributeStyle(ERDViewStyle.ENTITY_FQN);
        EntityFigure figure = new EntityFigure(this.getTable(), useFQN);
        EntityDiagram.NodeVisualInfo visualInfo = diagram.getVisualInfo(this.getTable());
        if (visualInfo != null) {
            if (visualInfo.initBounds != null) {
                figure.setLocation(visualInfo.initBounds.getLocation());
            }
            this.customBackground = visualInfo.bgColor;
            if (this.customBackground != null) {
                figure.setBackgroundColor(this.customBackground);
            }
        }
        return figure;
    }

    public EntityFigure getFigure() {
        return (EntityFigure)super.getFigure();
    }

    protected void refreshVisuals() {
        EntityFigure entityFigure = this.getFigure();
        Point location = entityFigure.getLocation();
        DiagramPart parent = (DiagramPart)this.getParent();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        parent.setLayoutConstraint((EditPart)this, (IFigure)entityFigure, constraint);
    }

    public EntityFigure getContentPane() {
        return this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public void setSelected(int value) {
        super.setSelected(value);
        EntityFigure entityFigure = this.getFigure();
        if (value != 0) {
            entityFigure.setSelected(true);
        } else {
            entityFigure.setSelected(false);
        }
        entityFigure.repaint();
    }

    public AssociationPart getConnectionPart(ERDAssociation rel, boolean source) {
        for (Object conn : source ? this.getSourceConnections() : this.getTargetConnections()) {
            if (!(conn instanceof AssociationPart) || ((AssociationPart)conn).getAssociation() != rel) continue;
            return (AssociationPart)conn;
        }
        return null;
    }

    public ERDGraphicalViewer getViewer() {
        return (ERDGraphicalViewer)super.getViewer();
    }

    @Override
    public void activate() {
        super.activate();
        this.getViewer().handleTableActivate((DBSEntity)this.getTable().getObject());
    }

    @Override
    public void deactivate() {
        this.getViewer().handleTableDeactivate((DBSEntity)this.getTable().getObject());
        super.deactivate();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

