/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class EntityDiagram
extends ERDObject<DBSObject> {
    private String name;
    private List<ERDEntity> entities = new ArrayList<ERDEntity>();
    private boolean layoutManualDesired = true;
    private boolean layoutManualAllowed = false;
    private Map<DBSEntity, ERDEntity> tableMap = new IdentityHashMap<DBSEntity, ERDEntity>();
    private Map<ERDObject, NodeVisualInfo> nodeVisuals = new IdentityHashMap<ERDObject, NodeVisualInfo>();
    private List<ERDNote> notes = new ArrayList<ERDNote>();
    private boolean needsAutoLayout;
    private ERDAttributeVisibility attributeVisibility = ERDAttributeVisibility.PRIMARY;
    private ERDViewStyle[] attributeStyles = new ERDViewStyle[]{ERDViewStyle.ICONS};
    private List<String> errorMessages = new ArrayList<String>();

    public EntityDiagram(DBSObject container, String name) {
        super(container);
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
        this.attributeVisibility = ERDAttributeVisibility.getDefaultVisibility(store);
        this.attributeStyles = ERDViewStyle.getDefaultStyles(store);
    }

    public boolean hasAttributeStyle(ERDViewStyle style) {
        return ArrayUtils.contains((Object[])this.attributeStyles, (Object)((Object)style));
    }

    public void setAttributeStyle(ERDViewStyle style, boolean enable) {
        this.attributeStyles = enable ? (ERDViewStyle[])ArrayUtils.add(ERDViewStyle.class, (Object[])this.attributeStyles, (Object)((Object)style)) : (ERDViewStyle[])ArrayUtils.remove(ERDViewStyle.class, (Object[])this.attributeStyles, (Object)((Object)style));
        ERDViewStyle.setDefaultStyles(ERDActivator.getDefault().getPreferences(), this.attributeStyles);
    }

    public ERDAttributeVisibility getAttributeVisibility() {
        return this.attributeVisibility;
    }

    public void setAttributeVisibility(ERDAttributeVisibility attributeVisibility) {
        this.attributeVisibility = attributeVisibility;
        ERDAttributeVisibility.setDefaultVisibility(ERDActivator.getDefault().getPreferences(), attributeVisibility);
    }

    public synchronized void addTable(ERDEntity entity, boolean reflect) {
        this.addTable(entity, -1, reflect);
    }

    public synchronized void addTable(ERDEntity entity, int i, boolean reflect) {
        if (i < 0) {
            this.entities.add(entity);
        } else {
            this.entities.add(i, entity);
        }
        this.tableMap.put((DBSEntity)entity.getObject(), entity);
        if (reflect) {
            this.firePropertyChange("CHILD", null, entity);
        }
        this.resolveRelations(reflect);
        if (reflect) {
            for (ERDAssociation rel : entity.getPrimaryKeyRelationships()) {
                rel.getForeignKeyEntity().firePropertyChange("OUTPUT", null, rel);
            }
        }
    }

    private void resolveRelations(boolean reflect) {
        for (ERDEntity erdEntity : this.getEntities()) {
            erdEntity.resolveRelations(this.tableMap, reflect);
        }
    }

    public synchronized void removeTable(ERDEntity entity, boolean reflect) {
        this.tableMap.remove(entity.getObject());
        this.entities.remove(entity);
        if (reflect) {
            this.firePropertyChange("CHILD", entity, null);
        }
    }

    public synchronized List<ERDEntity> getEntities() {
        return this.entities;
    }

    public synchronized List<ERDNote> getNotes() {
        return this.notes;
    }

    public synchronized void addNote(ERDNote note, boolean reflect) {
        this.notes.add(note);
        if (reflect) {
            this.firePropertyChange("CHILD", null, note);
        }
    }

    public synchronized void removeNote(ERDNote note, boolean reflect) {
        this.notes.remove(note);
        if (reflect) {
            this.firePropertyChange("CHILD", note, null);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLayoutManualAllowed(boolean layoutManualAllowed) {
        this.layoutManualAllowed = layoutManualAllowed;
    }

    public boolean isLayoutManualDesired() {
        return this.layoutManualDesired;
    }

    public void setLayoutManualDesired(boolean layoutManualDesired) {
        this.layoutManualDesired = layoutManualDesired;
    }

    public boolean isLayoutManualAllowed() {
        return this.layoutManualAllowed;
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public EntityDiagram copy() {
        EntityDiagram copy = new EntityDiagram((DBSObject)this.getObject(), this.getName());
        copy.entities.addAll(this.entities);
        copy.tableMap.putAll(this.tableMap);
        copy.layoutManualDesired = this.layoutManualDesired;
        copy.layoutManualAllowed = this.layoutManualAllowed;
        copy.nodeVisuals = this.nodeVisuals;
        return copy;
    }

    public void fillTables(DBRProgressMonitor monitor, Collection<DBSEntity> tables, DBSObject dbObject) {
        ERDEntity erdEntity;
        monitor.beginTask("Load entities metadata", tables.size());
        for (DBSEntity table : tables) {
            if (monitor.isCanceled()) break;
            monitor.subTask("Load " + table.getName());
            erdEntity = ERDEntity.fromObject(monitor, this, table);
            erdEntity.setPrimary(table == dbObject);
            this.addTable(erdEntity, false);
            this.tableMap.put(table, erdEntity);
            monitor.worked(1);
        }
        monitor.done();
        monitor.beginTask("Load entities' relations", tables.size());
        for (DBSEntity table : tables) {
            if (monitor.isCanceled()) break;
            monitor.subTask("Load " + table.getName());
            erdEntity = this.tableMap.get(table);
            if (erdEntity != null) {
                erdEntity.addRelations(monitor, this.tableMap, false);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public boolean containsTable(DBSEntity table) {
        for (ERDEntity erdEntity : this.entities) {
            if (erdEntity.getObject() != table) continue;
            return true;
        }
        return false;
    }

    public Map<DBSEntity, ERDEntity> getTableMap() {
        return this.tableMap;
    }

    public ERDEntity getERDTable(DBSEntity table) {
        return this.tableMap.get(table);
    }

    public void clear() {
        this.entities.clear();
        this.tableMap.clear();
        this.nodeVisuals.clear();
    }

    public NodeVisualInfo getVisualInfo(ERDObject erdObject) {
        return this.getVisualInfo(erdObject, false);
    }

    public NodeVisualInfo getVisualInfo(ERDObject erdObject, boolean create) {
        NodeVisualInfo visualInfo = this.nodeVisuals.get(erdObject);
        if (visualInfo == null && create) {
            visualInfo = new NodeVisualInfo();
            this.nodeVisuals.put(erdObject, visualInfo);
        }
        return visualInfo;
    }

    public void addVisualInfo(ERDObject erdTable, NodeVisualInfo visualInfo) {
        this.nodeVisuals.put(erdTable, visualInfo);
    }

    public boolean isNeedsAutoLayout() {
        return this.needsAutoLayout;
    }

    public void setNeedsAutoLayout(boolean needsAutoLayout) {
        this.needsAutoLayout = needsAutoLayout;
    }

    public void addInitRelationBends(ERDEntity sourceEntity, ERDEntity targetEntity, String relName, List<Point> bends) {
        for (ERDAssociation rel : sourceEntity.getPrimaryKeyRelationships()) {
            if (rel.getForeignKeyEntity() != targetEntity || !relName.equals(((DBSEntityAssociation)rel.getObject()).getName())) continue;
            rel.setInitBends(bends);
        }
    }

    public List<ERDObject> getContents() {
        ArrayList<ERDObject> children = new ArrayList<ERDObject>(this.entities.size() + this.notes.size());
        children.addAll(this.entities);
        children.addAll(this.notes);
        children.sort(new Comparator<ERDObject>(){

            @Override
            public int compare(ERDObject o1, ERDObject o2) {
                NodeVisualInfo vi1 = EntityDiagram.this.getVisualInfo(o1);
                NodeVisualInfo vi2 = EntityDiagram.this.getVisualInfo(o2);
                return vi1 != null && vi2 != null ? vi1.zOrder - vi2.zOrder : 0;
            }
        });
        return children;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public static class NodeVisualInfo {
        public Rectangle initBounds;
        public Color bgColor;
        public int zOrder = 0;
    }
}

