/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public abstract class ERDObject<OBJECT>
implements IAdaptable,
DBPNamedObject {
    private static final Log log = Log.getLog(ERDObject.class);
    public static final String CHILD = "CHILD";
    public static final String REORDER = "REORDER";
    public static final String INPUT = "INPUT";
    public static final String OUTPUT = "OUTPUT";
    public static final String NAME = "NAME";
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    protected OBJECT object;
    private PropertyCollector propertyCollector = null;

    protected ERDObject(OBJECT object) {
        this.object = object;
    }

    public OBJECT getObject() {
        return this.object;
    }

    public void setObject(OBJECT object) {
        this.object = object;
    }

    private PropertyCollector getPropertyCollector() {
        if (this.propertyCollector == null) {
            this.propertyCollector = new PropertyCollector(this.object, false);
            if (this.object != null) {
                this.propertyCollector.collectProperties();
            }
        }
        return this.propertyCollector;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public void openEditor() {
        if (this.object instanceof DBSObject) {
            UIUtils.runUIJob((String)"Open object editor", monitor -> {
                DBNDatabaseNode node = NavigatorUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((DBSObject)this.object), (boolean)true);
                if (node != null) {
                    NavigatorUtils.openNavigatorNode((Object)node, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                }
            });
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBPPropertySource.class) {
            return adapter.cast(this.getPropertyCollector());
        }
        return null;
    }
}

