/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDLogicalForeignKey;
import org.jkiss.dbeaver.ext.erd.model.ERDLogicalPrimaryKey;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;

public class ERDAssociation
extends ERDObject<DBSEntityAssociation> {
    private static final Log log = Log.getLog(ERDAssociation.class);
    private ERDEntity primaryKeyEntity;
    private ERDEntity foreignKeyEntity;
    private List<Point> initBends;
    private Boolean identifying;

    public ERDAssociation(ERDEntity foreignEntity, ERDEntity primaryEntity, boolean reflect) {
        super(new ERDLogicalForeignKey(foreignEntity, String.valueOf(((DBSEntity)foreignEntity.getObject()).getName()) + " -> " + ((DBSEntity)primaryEntity.getObject()).getName(), "", new ERDLogicalPrimaryKey(primaryEntity, "Primary key", "")));
        this.primaryKeyEntity = primaryEntity;
        this.foreignKeyEntity = foreignEntity;
        this.primaryKeyEntity.addPrimaryKeyRelationship(this, reflect);
        this.foreignKeyEntity.addForeignKeyRelationship(this, reflect);
    }

    public ERDAssociation(DBSEntityAssociation object, ERDEntity foreignEntity, ERDEntity primaryEntity, boolean reflect) {
        super(object);
        this.primaryKeyEntity = primaryEntity;
        this.foreignKeyEntity = foreignEntity;
        this.primaryKeyEntity.addPrimaryKeyRelationship(this, reflect);
        this.foreignKeyEntity.addForeignKeyRelationship(this, reflect);
    }

    public boolean isLogical() {
        return this.getObject() instanceof ERDLogicalForeignKey;
    }

    public ERDEntity getForeignKeyEntity() {
        return this.foreignKeyEntity;
    }

    public ERDEntity getPrimaryKeyEntity() {
        return this.primaryKeyEntity;
    }

    public void setPrimaryKeyEntity(ERDEntity targetPrimaryKey) {
        this.primaryKeyEntity = targetPrimaryKey;
    }

    public void setForeignKeyEntity(ERDEntity sourceForeignKey) {
        this.foreignKeyEntity = sourceForeignKey;
    }

    public List<Point> getInitBends() {
        return this.initBends;
    }

    public void setInitBends(List<Point> bends) {
        this.initBends = bends;
    }

    public boolean isIdentifying() {
        if (this.identifying == null) {
            this.identifying = false;
            try {
                this.identifying = DBUtils.isIdentifyingAssociation((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAssociation)((DBSEntityAssociation)this.getObject()));
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return this.identifying;
    }

    public String toString() {
        return this.getObject() + " [" + this.primaryKeyEntity + "->" + this.foreignKeyEntity + "]";
    }

    @NotNull
    public String getName() {
        return ((DBSEntityAssociation)this.getObject()).getName();
    }
}

