/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum ERDViewStyle {
    ICONS(1, "Icons"),
    TYPES(2, "Data Types"),
    NULLABILITY(4, "Nullability"),
    COMMENTS(8, "Comments"),
    ENTITY_FQN(16, "Fully qualified names");

    private final int value;
    private final String title;
    private static final Log log;

    static {
        log = Log.getLog(ERDAttributeVisibility.class);
    }

    private ERDViewStyle(int value, String title) {
        this.value = value;
        this.title = title;
    }

    public int getValue() {
        return this.value;
    }

    public String getTitle() {
        return this.title;
    }

    public static ERDViewStyle[] getDefaultStyles(IPreferenceStore store) {
        String attrString = store.getString("erd.attr.styles");
        if (!CommonUtils.isEmpty((String)attrString)) {
            String[] psList = attrString.split(",");
            ERDViewStyle[] pList = new ERDViewStyle[psList.length];
            int i = 0;
            while (i < psList.length) {
                try {
                    pList[i] = ERDViewStyle.valueOf(psList[i]);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
                ++i;
            }
            return pList;
        }
        return new ERDViewStyle[]{ICONS};
    }

    public static void setDefaultStyles(DBPPreferenceStore store, ERDViewStyle[] styles) {
        String stylesString = "";
        ERDViewStyle[] eRDViewStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            ERDViewStyle style = eRDViewStyleArray[n2];
            if (!stylesString.isEmpty()) {
                stylesString = String.valueOf(stylesString) + ",";
            }
            stylesString = String.valueOf(stylesString) + style.name();
            ++n2;
        }
        store.setValue("erd.attr.styles", stylesString);
    }
}

