/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;

public class AssociationReconnectSourceCommand
extends Command {
    protected ERDEntity sourceForeignKey;
    protected ERDEntity targetPrimaryKey;
    protected ERDAssociation relationship;
    protected ERDEntity oldSourceForeignKey;

    public boolean canExecute() {
        boolean returnVal = true;
        ERDEntity primaryKeyEntity = this.relationship.getPrimaryKeyEntity();
        if (primaryKeyEntity.equals(this.sourceForeignKey)) {
            returnVal = false;
        } else {
            List<ERDAssociation> relationships = this.sourceForeignKey.getForeignKeyRelationships();
            int i = 0;
            while (i < relationships.size()) {
                ERDAssociation relationship = relationships.get(i);
                if (relationship.getPrimaryKeyEntity().equals(this.targetPrimaryKey) && relationship.getForeignKeyEntity().equals(this.sourceForeignKey)) {
                    returnVal = false;
                    break;
                }
                ++i;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.sourceForeignKey != null) {
            this.oldSourceForeignKey.removeForeignKeyRelationship(this.relationship, true);
            this.relationship.setForeignKeyEntity(this.sourceForeignKey);
            this.sourceForeignKey.addForeignKeyRelationship(this.relationship, true);
        }
    }

    public ERDEntity getSourceForeignKey() {
        return this.sourceForeignKey;
    }

    public void setSourceForeignKey(ERDEntity sourceForeignKey) {
        this.sourceForeignKey = sourceForeignKey;
    }

    public ERDEntity getTargetPrimaryKey() {
        return this.targetPrimaryKey;
    }

    public void setTargetPrimaryKey(ERDEntity targetPrimaryKey) {
        this.targetPrimaryKey = targetPrimaryKey;
    }

    public ERDAssociation getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ERDAssociation relationship) {
        this.relationship = relationship;
        this.targetPrimaryKey = relationship.getPrimaryKeyEntity();
        this.oldSourceForeignKey = relationship.getForeignKeyEntity();
    }

    public void undo() {
        this.sourceForeignKey.removeForeignKeyRelationship(this.relationship, true);
        this.relationship.setForeignKeyEntity(this.oldSourceForeignKey);
        this.oldSourceForeignKey.addForeignKeyRelationship(this.relationship, true);
    }
}

