/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.views;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class RedisKeysConfigPage
extends ConnectionPageAbstract {
    private static String KEY_FILTER_DIV = "@@filter@@";
    private Composite settingsGroup;
    private boolean activated;
    private Combo keyDivider;
    private Spinner keyCountSpinner;
    private Spinner patternCountSpinner;
    private Table keyFilterTable;
    private Button addKeyButton;
    private Button removeKeyButton;

    public RedisKeysConfigPage() {
        this.setTitle("Keys settings");
        this.setDescription("Redis keys reading settings");
    }

    public void createControl(Composite composite) {
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
        this.loadSettings();
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group keysGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Keys", (int)2, (int)768, (int)-1);
        this.keyDivider = UIUtils.createLabelCombo((Composite)keysGroup, (String)"Key group divider", (int)2052);
        this.keyDivider.add(":");
        this.keyDivider.add(".");
        this.keyDivider.add("/");
        this.keyDivider.add("\\");
        this.keyDivider.add("|");
        this.keyDivider.add("^");
        this.keyDivider.add("$");
        gd = new GridData(32);
        gd.widthHint = 30;
        this.keyDivider.setLayoutData((Object)gd);
        this.keyDivider.addModifyListener(textListener);
        this.keyCountSpinner = UIUtils.createLabelSpinner((Composite)keysGroup, (String)"Max keys read", (String)"Maximum number of keys to read", (int)10000, (int)0, (int)Integer.MAX_VALUE);
        this.keyCountSpinner.setIncrement(1000);
        gd = new GridData(32);
        gd.widthHint = 60;
        this.keyCountSpinner.setLayoutData((Object)gd);
        this.keyCountSpinner.addModifyListener(textListener);
        this.patternCountSpinner = UIUtils.createLabelSpinner((Composite)keysGroup, (String)"Max cache read", (String)"Number of keys to read with pattern (cache)", (int)100000, (int)0, (int)Integer.MAX_VALUE);
        this.patternCountSpinner.setIncrement(1000);
        gd = new GridData(32);
        gd.widthHint = 60;
        this.patternCountSpinner.setLayoutData((Object)gd);
        this.patternCountSpinner.addModifyListener(textListener);
        Composite filterGroup = UIUtils.createPlaceholder((Composite)keysGroup, (int)2, (int)5);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        filterGroup.setLayoutData((Object)gd);
        Label filterLabel = UIUtils.createControlLabel((Composite)filterGroup, (String)"Key filters");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        filterLabel.setLayoutData((Object)gd);
        this.keyFilterTable = new Table(filterGroup, 67588);
        UIUtils.createTableColumn((Table)this.keyFilterTable, (int)16384, (String)"Filter");
        gd = new GridData(768);
        gd.heightHint = this.keyFilterTable.getItemHeight() * 4;
        this.keyFilterTable.setLayoutData((Object)gd);
        this.keyFilterTable.setLinesVisible(true);
        this.keyFilterTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RedisKeysConfigPage.this.keyFilterTable.getSelectionIndex() < 0) {
                    RedisKeysConfigPage.this.removeKeyButton.setEnabled(false);
                }
            }
        });
        this.keyFilterTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                RedisKeysConfigPage.this.keyFilterTable.removeListener(11, (Listener)this);
                UIUtils.packColumns((Table)RedisKeysConfigPage.this.keyFilterTable, (boolean)true);
            }
        });
        final CustomTableEditor tableEditor = new CustomTableEditor(this.keyFilterTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                Text text = new Text((Composite)table, 2048);
                text.setText(item.getText(index));
                text.selectAll();
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(index, ((Text)control).getText());
            }
        };
        Composite keysCtrl = UIUtils.createPlaceholder((Composite)filterGroup, (int)1);
        gd = new GridData(2);
        keysCtrl.setLayoutData((Object)gd);
        this.addKeyButton = UIUtils.createPushButton((Composite)keysCtrl, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(RedisKeysConfigPage.this.keyFilterTable, 0);
                item.setText("*");
                RedisKeysConfigPage.this.keyFilterTable.setSelection(item);
                tableEditor.showEditor(item);
            }
        });
        this.removeKeyButton = UIUtils.createPushButton((Composite)keysCtrl, null, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = RedisKeysConfigPage.this.keyFilterTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.dispose();
                    ++n2;
                }
            }
        });
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.keyDivider != null) {
            String keyDivString = connectionInfo.getProviderProperty("@dbeaver-redis.key.divider");
            if (keyDivString == null) {
                keyDivString = ":";
            }
            this.keyDivider.setText(keyDivString);
            this.keyCountSpinner.setSelection(CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.key.read.count"), (int)10000));
            this.patternCountSpinner.setSelection(CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.pattern.read.count"), (int)100000));
            String keyFilters = connectionInfo.getProviderProperty("@dbeaver-redis.key.filters");
            if (keyFilters == null) {
                keyFilters = "";
            }
            String[] stringArray = keyFilters.split(KEY_FILTER_DIV);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (!filter.isEmpty()) {
                    TableItem item = new TableItem(this.keyFilterTable, 0);
                    item.setText(filter);
                }
                ++n2;
            }
        }
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProviderProperty("@dbeaver-redis.key.divider", this.keyDivider.getText());
        connectionInfo.setProviderProperty("@dbeaver-redis.key.read.count", String.valueOf(this.keyCountSpinner.getSelection()));
        connectionInfo.setProviderProperty("@dbeaver-redis.pattern.read.count", String.valueOf(this.patternCountSpinner.getSelection()));
        StringBuilder filters = new StringBuilder();
        TableItem[] tableItemArray = this.keyFilterTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (filters.length() > 0) {
                filters.append(KEY_FILTER_DIV);
            }
            filters.append(item.getText());
            ++n2;
        }
        connectionInfo.setProviderProperty("@dbeaver-redis.key.filters", filters.toString());
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }
}

