/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis;

import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDataSource;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisUtils {
    private static final Log log;
    public static final List<String> NULL_SUB_KEYS;
    public static Map<String, Method[]> COMMAND_METHODS;

    static {
        Method[] jedisMethods;
        log = Log.getLog(RedisUtils.class);
        NULL_SUB_KEYS = Collections.emptyList();
        COMMAND_METHODS = new HashMap<String, Method[]>();
        Method[] methodArray = jedisMethods = Jedis.class.getMethods();
        int n = jedisMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isAnnotationPresent(Deprecated.class) && method.getReturnType() != byte[].class) {
                boolean hasBadParams = false;
                Class<?>[] classArray = method.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> paramType = classArray[n4];
                    if (paramType.isArray()) {
                        hasBadParams = true;
                        break;
                    }
                    ++n4;
                }
                if (!hasBadParams) {
                    String commandName = method.getName().toLowerCase(Locale.ENGLISH);
                    Object[] methods = COMMAND_METHODS.get(commandName);
                    methods = methods == null ? new Method[]{method} : (Method[])ArrayUtils.add(Method.class, (Object[])methods, (Object)method);
                    COMMAND_METHODS.put(commandName, (Method[])methods);
                }
            }
            ++n2;
        }
    }

    public static Map<String, String> parseInfo(String info) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new StringReader(info));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) {
                        break;
                    }
                    int divPos = line.indexOf(58);
                    if (divPos == -1) continue;
                    String name = line.substring(0, divPos);
                    String value = line.substring(divPos + 1);
                    map.put(name, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<RedisKey> getKeys(@NotNull DBRProgressMonitor monitor, @NotNull RedisDatabase database, @Nullable RedisKey parent, @Nullable String pattern, boolean showHierarchy) throws DBCException {
        RedisDataSource dataSource = database.getDataSource();
        DBPConnectionConfiguration props = database.getDataSource().getContainer().getConnectionConfiguration();
        String divider = database.getDataSource().getKeyDivider();
        if (parent != null && !showHierarchy) {
            return Collections.emptyList();
        }
        int maxKeys = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.key.read.count"), (int)10000);
        int maxPatternRead = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.pattern.read.count"), (int)100000);
        RedisDatabase prevDatabase = dataSource.getDefaultObject();
        monitor.beginTask("Read keys", 1);
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try {
                ArrayList<RedisKey> arrayList;
                RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)database.getDataSource(), (String)"Read keys");
                Jedis jedis = session.getJedis();
                if (database != prevDatabase) {
                    jedis.select(database.getId());
                }
                ScanParams params = new ScanParams();
                String cursorPattern = null;
                String parentName = null;
                if (parent != null) {
                    parentName = parent.getFullyQualifiedName(DBPEvaluationContext.DML);
                    cursorPattern = String.valueOf(parentName) + divider;
                    cursorPattern = !CommonUtils.isEmpty((String)pattern) ? String.valueOf(cursorPattern) + pattern : String.valueOf(cursorPattern) + "*";
                } else if (!CommonUtils.isEmpty((String)pattern)) {
                    cursorPattern = pattern;
                }
                if (cursorPattern != null) {
                    params.match(cursorPattern);
                    params.count(maxPatternRead);
                } else {
                    params.count(maxKeys);
                }
                TreeMap<void, List<String>> keyMap = new TreeMap<void, List<String>>();
                int totalKeysRead = 0;
                int totalIterations = 0;
                String cursorId = "0";
                log.debug((Object)("Read Redis keys " + cursorPattern));
                while (!monitor.isCanceled()) {
                    ScanResult scanResult = jedis.scan(cursorId, params);
                    cursorId = scanResult.getStringCursor();
                    ++totalIterations;
                    List scanKeys = scanResult.getResult();
                    for (String string : scanKeys) {
                        void var24_27;
                        void var24_31;
                        String string2;
                        if (totalKeysRead++ >= maxKeys) break;
                        if (parent != null && showHierarchy && string.startsWith(parentName) && (string2 = string.substring(parentName.length())).startsWith(divider)) {
                            String string3 = string2.substring(divider.length());
                        }
                        int divPos = showHierarchy ? var24_31.indexOf(divider) : -1;
                        String subKey = null;
                        if (divPos != -1) {
                            subKey = var24_31.substring(divPos + 1);
                            String string4 = var24_31.substring(0, divPos);
                        }
                        if (subKey != null) {
                            ArrayList<String> subKeys = (ArrayList<String>)keyMap.get(var24_27);
                            if (subKeys == null || subKeys == NULL_SUB_KEYS) {
                                subKeys = new ArrayList<String>();
                                keyMap.put(var24_27, subKeys);
                            }
                            subKeys.add(subKey);
                            continue;
                        }
                        if (keyMap.containsKey(var24_27)) continue;
                        keyMap.put(var24_27, NULL_SUB_KEYS);
                    }
                    if (totalKeysRead++ < maxKeys && !cursorId.equals("0")) continue;
                }
                log.debug((Object)("Read " + totalKeysRead + " keys in " + totalIterations + " iterations"));
                boolean readAll = totalKeysRead < maxKeys;
                ArrayList<RedisKey> keys = new ArrayList<RedisKey>();
                Iterator<Object> iterator = keyMap.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        arrayList = keys;
                        break;
                    }
                    Map.Entry entry = (Map.Entry)iterator.next();
                    RedisKey redisKey = new RedisKey(database, parent, (String)entry.getKey(), !((List)entry.getValue()).isEmpty());
                    keys.add(redisKey);
                    if (!readAll) continue;
                    Collections.sort((List)entry.getValue());
                    redisKey.setSubKeys((List)entry.getValue(), divider);
                }
                monitor.done();
                return arrayList;
                {
                    finally {
                        if (prevDatabase != null && prevDatabase != database) {
                            jedis.select(prevDatabase.getId());
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
    }

    public static boolean isCommand(String command) {
        return COMMAND_METHODS.containsKey(command);
    }
}

