/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.snowflake;

import com.dbeaver.ee.snowflake.model.SnowflakeDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SnowflakeDataSourceProvider
extends JDBCDataSourceProvider {
    private static final Log log = Log.getLog(SnowflakeDataSourceProvider.class);

    public void init(@NotNull DBPPlatform dBPPlatform) {
    }

    public long getFeatures() {
        return 2L;
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor dBRProgressMonitor, DBPDriver dBPDriver, DBPConnectionConfiguration dBPConnectionConfiguration) throws DBException {
        return null;
    }

    public String getConnectionURL(DBPDriver dBPDriver, DBPConnectionConfiguration dBPConnectionConfiguration) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("jdbc:snowflake://").append(dBPConnectionConfiguration.getHostName());
        if (!CommonUtils.isEmpty((String)dBPConnectionConfiguration.getHostPort())) {
            stringBuilder.append(":").append(dBPConnectionConfiguration.getHostPort());
        }
        stringBuilder.append("/?");
        boolean bl = SnowflakeDataSourceProvider.addParameter(stringBuilder, "db", dBPConnectionConfiguration.getDatabaseName(), false);
        bl = SnowflakeDataSourceProvider.addParameter(stringBuilder, "warehouse", dBPConnectionConfiguration.getServerName(), bl);
        bl = SnowflakeDataSourceProvider.addParameter(stringBuilder, "schema", dBPConnectionConfiguration.getProviderProperty("@dbeaver-schema@"), bl);
        SnowflakeDataSourceProvider.addParameter(stringBuilder, "role", dBPConnectionConfiguration.getProviderProperty("@dbeaver-role@"), bl);
        return stringBuilder.toString();
    }

    private static boolean addParameter(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (!CommonUtils.isEmpty((String)string2)) {
            if (bl) {
                stringBuilder.append("&");
            }
            stringBuilder.append(string).append("=").append(string2);
            return true;
        }
        return bl;
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull DBPDataSourceContainer dBPDataSourceContainer) throws DBException {
        return new SnowflakeDataSource(dBRProgressMonitor, dBPDataSourceContainer, new GenericMetaModel());
    }
}

