/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDialect;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class SQLServerDataSource
extends GenericDataSource {
    public SQLServerDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        this(monitor, container, new SQLServerMetaModel(container.getDriver().getSampleURL().contains(":sqlserver")));
    }

    SQLServerDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SQLServerMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new SQLServerDialect());
    }

    public Object getDataSourceFeature(String featureId) {
        if ("datasource.limit-affects-dml".equals(featureId)) {
            return true;
        }
        return super.getDataSourceFeature(featureId);
    }

    protected boolean isShowAllSchemas() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-show-all-schemas@"));
    }

    protected String getConnectionUserName(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserName(connectionInfo);
    }

    protected String getConnectionUserPassword(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserPassword(connectionInfo);
    }
}

