/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.CommonUtils;

public class GenericDataSourceProvider
extends JDBCDataSourceProvider {
    private final Map<String, GenericMetaModelDescriptor> metaModels = new HashMap<String, GenericMetaModelDescriptor>();
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.generic.meta";

    public GenericDataSourceProvider() {
        IConfigurationElement[] extElements;
        this.metaModels.put("standard", new GenericMetaModelDescriptor());
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElements = extensionRegistry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            GenericMetaModelDescriptor metaModel = new GenericMetaModelDescriptor(ext);
            this.metaModels.put(metaModel.getId(), metaModel);
            String[] stringArray = metaModel.getDriverClass();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String driverClass = stringArray[n4];
                this.metaModels.put(driverClass, metaModel);
                ++n4;
            }
            ++n2;
        }
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        try {
            String urlTemplate = driver.getSampleURL();
            if (CommonUtils.isEmptyTrimmed((String)urlTemplate)) {
                return connectionInfo.getUrl();
            }
            DriverDescriptor.MetaURL metaURL = DriverDescriptor.parseSampleURL((String)urlTemplate);
            StringBuilder url = new StringBuilder();
            Iterator iterator = metaURL.getUrlComponents().iterator();
            while (iterator.hasNext()) {
                String component;
                String newComponent = component = (String)iterator.next();
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                    newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("host"), connectionInfo.getHostName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("port"), connectionInfo.getHostPort());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                    newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("server"), connectionInfo.getServerName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("database"), connectionInfo.getDatabaseName());
                    newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("folder"), connectionInfo.getDatabaseName());
                    newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("file"), connectionInfo.getDatabaseName());
                }
                newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("user"), CommonUtils.notEmpty((String)connectionInfo.getUserName()));
                if ((newComponent = newComponent.replace(GenericDataSourceProvider.makePropPattern("password"), CommonUtils.notEmpty((String)connectionInfo.getUserPassword()))).startsWith("[")) {
                    if (newComponent.equals(component)) continue;
                    url.append(newComponent.substring(1, newComponent.length() - 1));
                    continue;
                }
                url.append(newComponent);
            }
            return url.toString();
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        GenericMetaModelDescriptor metaModel = null;
        Object metaModelId = container.getDriver().getDriverParameter("meta-model");
        if (metaModelId != null && !"standard".equals(metaModelId) && (metaModel = this.metaModels.get(metaModelId.toString())) == null) {
            log.warn((Object)("Meta model '" + metaModelId + "' not recognized. Default one will be used"));
        }
        if (metaModel == null) {
            metaModel = this.metaModels.get(container.getDriver().getDriverClassName());
        }
        if (metaModel == null) {
            metaModel = this.getStandardMetaModel();
        }
        GenericMetaModel metaModelInstance = metaModel.getInstance();
        return metaModelInstance.createDataSourceImpl(monitor, container);
    }

    protected GenericMetaModelDescriptor getStandardMetaModel() {
        return this.metaModels.get("standard");
    }

    private static String makePropPattern(String prop) {
        return "{" + prop + "}";
    }
}

