/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2ColumnDataTypeListProvider;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2ColumnHiddenState;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableColumnCompression;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableColumnGenerated;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class DB2TableColumn
extends JDBCTableColumn<DB2TableBase>
implements DBSTableColumn,
DBSTypedObjectEx,
DBPHiddenObject,
DBPNamedObject2 {
    private DB2DataType dataType;
    private DB2Schema dataTypeSchema;
    private String remarks;
    private DB2ColumnHiddenState hidden;
    private Boolean identity;
    private Boolean lobCompact;
    private DB2TableColumnGenerated generated;
    private String generatedText;
    private DB2TableColumnCompression compress;
    private String rowBegin;
    private String rowEnd;
    private String transactionStartId;
    private String collationSchema;
    private String collationNane;
    private String typeStringUnits;
    private Integer stringUnitsLength;
    private String stringLength;
    private Integer keySeq;
    private Integer partKeySeq;
    private Long colcard;
    private String high2key;
    private String low2key;
    private Integer avgLength;
    private Integer nbQuantiles;
    private Integer nbMostFreq;
    private Long nbNulls;
    private Integer pctInlined;
    private Integer pctEncoded;
    private boolean hiddenState;

    public DB2TableColumn(DBRProgressMonitor monitor, DB2TableBase tableBase, ResultSet dbResult) throws DBException {
        super((DBSEntity)tableBase, true);
        DB2DataSource db2DataSource = (DB2DataSource)tableBase.getDataSource();
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLNAME"));
        this.setOrdinalPosition(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLNO"));
        this.setRequired(JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NULLS", (String)DB2YesNo.N.name()));
        this.setDefaultValue(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT"));
        this.setMaxLength(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"LENGTH"));
        this.setScale(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SCALE"));
        this.hidden = (DB2ColumnHiddenState)CommonUtils.valueOf(DB2ColumnHiddenState.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HIDDEN"));
        this.identity = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IDENTITY", (String)DB2YesNo.Y.name());
        this.lobCompact = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"COMPACT", (String)DB2YesNo.Y.name());
        this.generated = (DB2TableColumnGenerated)CommonUtils.valueOf(DB2TableColumnGenerated.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"GENERATED"));
        this.generatedText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEXT");
        this.compress = (DB2TableColumnCompression)CommonUtils.valueOf(DB2TableColumnCompression.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPRESS"));
        this.colcard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"COLCARD");
        this.high2key = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HIGH2KEY");
        this.low2key = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOW2KEY");
        this.avgLength = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"AVGCOLLEN");
        this.nbNulls = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUMNULLS");
        this.keySeq = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"KEYSEQ");
        this.partKeySeq = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PARTKEYSEQ");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.collationSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLLATIONSCHEMA");
            this.collationNane = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONNAME");
            this.nbQuantiles = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"NQUANTILES");
            this.nbMostFreq = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"NMOSTFREQ");
        }
        if (db2DataSource.isAtLeastV9_7()) {
            this.pctInlined = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PCTINLINED");
        }
        if (db2DataSource.isAtLeastV10_1()) {
            this.rowBegin = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROWBEGIN");
            this.rowEnd = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROWEND");
            this.transactionStartId = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TRANSACTIONSTARTID");
        }
        if (db2DataSource.isAtLeastV10_5()) {
            this.typeStringUnits = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPESTRINGUNITS");
            this.stringUnitsLength = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"STRINGUNITSLENGTH");
            this.pctEncoded = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PCTENCODED");
            this.stringLength = this.typeStringUnits == null ? "" : this.stringUnitsLength + " " + this.typeStringUnits;
        }
        this.hiddenState = this.hidden == null ? false : this.hidden.isHidden();
        String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPENAME");
        this.dataType = (DB2DataType)((DB2DataSource)tableBase.getDataSource()).getDataTypeCache().getObject(monitor, (DBSObject)((DB2DataSource)((DB2TableBase)this.getTable()).getDataSource()), typeName);
        if (this.dataType == null) {
            String typeSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPESCHEMA");
            this.dataTypeSchema = this.getDataSource().getSchema(monitor, typeSchemaName);
            this.dataType = this.dataTypeSchema.getUDT(monitor, typeName);
        } else {
            this.dataTypeSchema = this.dataType.getSchema();
        }
        this.setTypeName(this.dataType.getFullyQualifiedName(DBPEvaluationContext.DML));
        this.setValueType(this.dataType.getTypeID());
    }

    public DB2TableColumn(DB2TableBase tableBase) {
        super((DBSEntity)tableBase, false);
        this.setMaxLength(50L);
        this.setOrdinalPosition(-1);
        this.dataType = (DB2DataType)((DB2DataSource)tableBase.getDataSource()).getDataTypeCache().getCachedObject("VARCHAR");
        this.dataTypeSchema = this.dataType.getSchema();
        this.setTypeName(this.dataType.getFullyQualifiedName(DBPEvaluationContext.DML));
        this.setValueType(this.dataType.getTypeID());
        this.setRequired(true);
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return (DB2DataSource)((DB2TableBase)this.getTable()).getDataSource();
    }

    public boolean isAutoGenerated() {
        return this.generated != null && this.generated.equals((Object)DB2TableColumnGenerated.A);
    }

    public boolean isHidden() {
        return this.hiddenState;
    }

    public DBPDataKind getDataKind() {
        return this.dataType.getDataKind();
    }

    public String getTypeName() {
        return super.getTypeName();
    }

    @Property(viewable=true, editable=false, order=19, category="Owner")
    public DB2TableBase getOwner() {
        return (DB2TableBase)this.getTable();
    }

    @Property(viewable=true, editable=false, order=20, category="Owner")
    public DB2Schema getTypeSchema() {
        return this.dataTypeSchema;
    }

    @Property(viewable=true, editable=true, updatable=true, order=21, listProvider=DB2ColumnDataTypeListProvider.class)
    @Nullable
    public DBSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DB2DataType dataType) {
        this.dataType = dataType;
        this.setTypeName(dataType.getTypeName());
    }

    @Property(viewable=true, editable=true, updatable=true, order=38)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Property(viewable=true, valueRenderer=DBPositiveNumberTransformer.class, order=39)
    public Integer getScale() {
        return super.getScale();
    }

    @Property(viewable=true, order=40)
    public String getStringLength() {
        return this.stringLength;
    }

    @Property(viewable=false, valueRenderer=DBPositiveNumberTransformer.class, order=42)
    public Integer getPrecision() {
        return super.getPrecision();
    }

    @Property(viewable=true, order=43, editable=true, updatable=true)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Property(viewable=true, order=44, editable=true)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Property(viewable=true, order=45)
    public Boolean getIdentity() {
        return this.identity;
    }

    @Property(viewable=false, order=46)
    public DB2TableColumnGenerated getGenerated() {
        return this.generated;
    }

    @Property(viewable=false, order=47)
    public String getGeneratedText() {
        return this.generatedText;
    }

    @Property(viewable=true, order=999, editable=true, updatable=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String remarks) {
        this.remarks = remarks;
    }

    @Property(viewable=false, order=134)
    public Boolean getLobCompact() {
        return this.lobCompact;
    }

    @Property(viewable=false, order=120)
    public Integer getKeySeq() {
        return this.keySeq;
    }

    @Property(viewable=false, order=121)
    public Integer getPartKeySeq() {
        return this.partKeySeq;
    }

    @Property(viewable=false, order=136)
    public DB2TableColumnCompression getCompress() {
        return this.compress;
    }

    @Property(viewable=false, order=137)
    public DB2ColumnHiddenState getHidden() {
        return this.hidden;
    }

    @Property(viewable=false, order=138, category="Temporal")
    public String getRowBegin() {
        return this.rowBegin;
    }

    @Property(viewable=false, order=139, category="Temporal")
    public String getRowEnd() {
        return this.rowEnd;
    }

    @Property(viewable=false, order=140, category="Temporal")
    public String getTransactionStartId() {
        return this.transactionStartId;
    }

    @Property(viewable=false, order=150, category="Statistics")
    public Long getColcard() {
        return this.colcard;
    }

    @Property(viewable=false, order=152, category="Statistics")
    public Integer getAvgLength() {
        return this.avgLength;
    }

    @Property(viewable=false, order=153, category="Statistics")
    public String getLow2key() {
        return this.low2key;
    }

    @Property(viewable=false, order=154, category="Statistics")
    public String getHigh2key() {
        return this.high2key;
    }

    @Property(viewable=false, order=155, category="Statistics")
    public Integer getPctInlined() {
        return this.pctInlined;
    }

    @Property(viewable=false, order=156, category="Statistics")
    public Integer getPctEncoded() {
        return this.pctEncoded;
    }

    @Property(viewable=false, order=157, category="Statistics")
    public Integer getNbQuantiles() {
        return this.nbQuantiles;
    }

    @Property(viewable=false, order=158, category="Statistics")
    public Integer getNbMostFreq() {
        return this.nbMostFreq;
    }

    @Property(viewable=false, order=159, category="Statistics")
    public Long getNbNulls() {
        return this.nbNulls;
    }

    @Property(viewable=false, order=180, category="Collation")
    public String getCollationSchema() {
        return this.collationSchema;
    }

    @Property(viewable=false, order=181, category="Collation")
    public String getCollationNane() {
        return this.collationNane;
    }
}

