/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2SequencePrecision;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2SequenceType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.utils.CommonUtils;

public class DB2Sequence
extends DB2SchemaObject
implements DBSSequence,
DBPRefreshableObject {
    private String owner;
    private DB2OwnerType ownerType;
    private Integer seqId;
    private DB2SequenceType seqType;
    private String baseSchema;
    private String baseSequence;
    private Long incrementBy;
    private Long start;
    private Long maxValue;
    private Long minValue;
    private Long nextCacheFirstValue;
    private Boolean cycle;
    private Integer cache;
    private Boolean order;
    private Integer dataTypeId;
    private Integer sourceTypeId;
    private Timestamp createTime;
    private Timestamp alterTime;
    private DB2SequencePrecision precision;
    private DB2OwnerType origin;
    private String remarks;

    public DB2Sequence(DB2Schema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEQNAME"), true);
        DB2DataSource db2DataSource = schema.getDataSource();
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.seqId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SEQID");
        this.seqType = (DB2SequenceType)CommonUtils.valueOf(DB2SequenceType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEQTYPE"));
        this.incrementBy = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INCREMENT");
        this.start = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"START");
        this.maxValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAXVALUE");
        this.minValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MINVALUE");
        this.nextCacheFirstValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NEXTCACHEFIRSTVALUE");
        this.cycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CYCLE", (String)DB2YesNo.Y.name());
        this.cache = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"CACHE");
        this.order = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ORDER", (String)DB2YesNo.Y.name());
        this.dataTypeId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DATATYPEID");
        this.sourceTypeId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SOURCETYPEID");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        this.precision = DB2SequencePrecision.getFromDataType(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PRECISION"));
        this.origin = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ORIGIN"));
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV9_7()) {
            this.baseSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"BASE_SEQSCHEMA");
            this.baseSequence = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"BASE_SEQNAME");
        }
    }

    public DB2Sequence(DB2Schema schema, String name) {
        super(schema, name, false);
        this.seqType = DB2SequenceType.S;
        this.origin = DB2OwnerType.U;
        this.ownerType = DB2OwnerType.U;
        this.precision = DB2SequencePrecision.P10;
        this.order = false;
        this.cycle = false;
        this.cache = 20;
        this.incrementBy = 1L;
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=false, order=2)
    public DB2Schema getSchema() {
        return super.getSchema();
    }

    @Property(viewable=true, editable=false, order=4)
    public DB2SequenceType getSeqType() {
        return this.seqType;
    }

    public Number getLastValue() {
        return this.getNextCacheFirstValue();
    }

    @Property(viewable=true, editable=false, order=5)
    public Long getNextCacheFirstValue() {
        return this.nextCacheFirstValue;
    }

    public void setNextCacheFirstValue(Long nextCacheFirstValue) {
        this.nextCacheFirstValue = nextCacheFirstValue;
    }

    @Property(viewable=false, editable=true, updatable=true, order=6)
    public Long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Long minValue) {
        this.minValue = minValue;
    }

    @Property(viewable=false, editable=true, updatable=true, order=6)
    public Long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Long maxValue) {
        this.maxValue = maxValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    @Property(viewable=true, editable=true, updatable=true, order=8)
    public Long getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(Long incrementBy) {
        this.incrementBy = incrementBy;
    }

    @Property(viewable=true, editable=true, updatable=true, order=9)
    public Integer getCache() {
        return this.cache;
    }

    public void setCache(Integer cache) {
        this.cache = cache;
    }

    @Property(viewable=true, editable=true, updatable=true, order=10)
    public Boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(Boolean cycle) {
        this.cycle = cycle;
    }

    @Property(viewable=true, editable=true, updatable=true, order=11)
    public Boolean getOrder() {
        return this.order;
    }

    public void setOrder(Boolean order) {
        this.order = order;
    }

    @Property(viewable=true, editable=true, order=12)
    public DB2SequencePrecision getPrecision() {
        return this.precision;
    }

    public void setPrecision(DB2SequencePrecision precision) {
        this.precision = precision;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, editable=false)
    public Integer getSeqId() {
        return this.seqId;
    }

    @Property(viewable=false, editable=false, category="Base Object")
    public String getBaseSchema() {
        return this.baseSchema;
    }

    @Property(viewable=false, editable=false, category="Base Object")
    public String getBaseSequence() {
        return this.baseSequence;
    }

    @Property(viewable=false, editable=false)
    public Integer getDataTypeId() {
        return this.dataTypeId;
    }

    @Property(viewable=false, editable=false)
    public Integer getSourceTypeId() {
        return this.sourceTypeId;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, editable=false, order=23)
    public DB2OwnerType getOrigin() {
        return this.origin;
    }

    @Override
    @Property(viewable=false, editable=true, updatable=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String remarks) {
        this.remarks = remarks;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }
}

