/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2PackageDep;
import org.jkiss.dbeaver.ext.db2.model.DB2PackageStatement;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2Package
extends DB2SchemaObject
implements DBPRefreshableObject {
    private static final String C_DEP = "SELECT * FROM SYSCAT.PACKAGEDEP WHERE PKGSCHEMA = ? AND PKGNAME = ? ORDER BY BSCHEMA,BNAME WITH UR";
    private static final String C_STM = "SELECT * FROM SYSCAT.STATEMENTS WHERE PKGSCHEMA = ? AND PKGNAME = ? ORDER BY SECTNO WITH UR";
    private final DBSObjectCache<DB2Package, DB2PackageDep> packageDepCache;
    private final DBSObjectCache<DB2Package, DB2PackageStatement> packageStatementsCache;
    private Boolean valid;
    private String owner;
    private DB2OwnerType ownerType;
    private DB2Schema defaultSchema;
    private String uniqueId;
    private Long id;
    private String version;
    private Integer totalSections;
    private String dateTimeFormat;
    private String isolation;
    private String concurrentAccessResolution;
    private String blocking;
    private Boolean insertBuf;
    private String langLevel;
    private String funcPath;
    private Integer queryOpt;
    private String degree;
    private Boolean multiNodePlan;
    private String intraParallel;
    private String validate;
    private String dynamicRules;
    private String sqlerror;
    private Boolean busTimeSensitive;
    private Boolean sysTimeSensitive;
    private Boolean keepDynamic;
    private Boolean staticAsDynamic;
    private Timestamp firstBindTime;
    private Timestamp lastBindTime;
    private Timestamp explicitBindTime;
    private Timestamp alterTime;
    private Date lastUsed;
    private String remarks;

    public DB2Package(DB2Schema schema, ResultSet dbResult) throws DBException {
        super(schema, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PKGNAME"), true);
        DB2DataSource db2DataSource = schema.getDataSource();
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        String defaultSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"DEFAULT_SCHEMA");
        this.defaultSchema = this.getDataSource().getSchema((DBRProgressMonitor)new VoidProgressMonitor(), defaultSchemaName);
        this.uniqueId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"UNIQUE_ID");
        this.valid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"VALID", (String)DB2YesNo.Y.name());
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PKGVERSION");
        this.totalSections = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TOTAL_SECT");
        this.dateTimeFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FORMAT");
        this.isolation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ISOLATION");
        this.blocking = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"BLOCKING");
        this.insertBuf = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"INSERT_BUF", (String)DB2YesNo.Y.name());
        this.langLevel = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LANG_LEVEL");
        this.funcPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNC_PATH");
        this.queryOpt = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"QUERYOPT");
        this.degree = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEGREE");
        this.multiNodePlan = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"MULTINODE_PLANS", (String)DB2YesNo.Y.name());
        this.intraParallel = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTRA_PARALLEL");
        this.validate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALIDATE");
        this.dynamicRules = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DYNAMICRULES");
        this.sqlerror = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQLERROR");
        this.lastBindTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_BIND_TIME");
        this.explicitBindTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"EXPLICIT_BIND_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV9_7()) {
            this.firstBindTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
            this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
            this.concurrentAccessResolution = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONCURRENTACCESSRESOLUTION");
            this.lastUsed = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"LASTUSED");
            this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PKGID");
        }
        if (schema.getDataSource().isAtLeastV10_1()) {
            this.busTimeSensitive = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"BUSTIMESENSITIVE", (String)DB2YesNo.Y.name());
            this.sysTimeSensitive = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"SYSTIMESENSITIVE", (String)DB2YesNo.Y.name());
            this.keepDynamic = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"KEEPDYNAMIC", (String)DB2YesNo.Y.name());
            this.staticAsDynamic = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"STATICASDYNAMIC", (String)DB2YesNo.Y.name());
        }
        this.packageDepCache = new JDBCObjectSimpleCache(DB2PackageDep.class, C_DEP, new Object[]{schema.getName(), this.getName()});
        this.packageStatementsCache = new JDBCObjectSimpleCache(DB2PackageStatement.class, C_STM, new Object[]{schema.getName(), this.getName()});
    }

    @Association
    public Collection<DB2PackageDep> getPackageDeps(DBRProgressMonitor monitor) throws DBException {
        return this.packageDepCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DB2PackageStatement> getStatements(DBRProgressMonitor monitor) throws DBException {
        return this.packageStatementsCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.packageDepCache.clearCache();
        return this;
    }

    @Property(viewable=true, order=3, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=true, order=4, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, order=5)
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Property(viewable=true, order=6)
    public Long getId() {
        return this.id;
    }

    @Property(viewable=true, order=7)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, order=8)
    public Boolean getValid() {
        return this.valid;
    }

    @Override
    @Property(viewable=false, order=9)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(viewable=true, order=20)
    public DB2Schema getDefaultSchema() {
        return this.defaultSchema;
    }

    @Property(viewable=true, order=21)
    public Integer getTotalSections() {
        return this.totalSections;
    }

    @Property(viewable=false, order=22)
    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Property(viewable=false, order=23)
    public String getIsolation() {
        return this.isolation;
    }

    @Property(viewable=false, order=24)
    public String getConcurrentAccessResolution() {
        return this.concurrentAccessResolution;
    }

    @Property(viewable=true, order=25)
    public String getBlocking() {
        return this.blocking;
    }

    @Property(viewable=false, order=26)
    public Boolean getInsertBuf() {
        return this.insertBuf;
    }

    @Property(viewable=false, order=27)
    public String getLangLevel() {
        return this.langLevel;
    }

    @Property(viewable=false, order=28)
    public String getFuncPath() {
        return this.funcPath;
    }

    @Property(viewable=true, order=29)
    public Integer getQueryOpt() {
        return this.queryOpt;
    }

    @Property(viewable=true, order=30)
    public String getDegree() {
        return this.degree;
    }

    @Property(viewable=false, order=31)
    public Boolean getMultiNodePlan() {
        return this.multiNodePlan;
    }

    @Property(viewable=false, order=32)
    public String getIntraParallel() {
        return this.intraParallel;
    }

    @Property(viewable=false, order=33)
    public String getValidate() {
        return this.validate;
    }

    @Property(viewable=false, order=34)
    public String getDynamicRules() {
        return this.dynamicRules;
    }

    @Property(viewable=false, order=35)
    public String getSqlerror() {
        return this.sqlerror;
    }

    @Property(viewable=false, order=36)
    public Boolean getBusTimeSensitive() {
        return this.busTimeSensitive;
    }

    @Property(viewable=false, order=37)
    public Boolean getSysTimeSensitive() {
        return this.sysTimeSensitive;
    }

    @Property(viewable=false, order=38)
    public Boolean getKeepDynamic() {
        return this.keepDynamic;
    }

    @Property(viewable=false, order=39)
    public Boolean getStaticAsDynamic() {
        return this.staticAsDynamic;
    }

    @Property(viewable=false, order=50, category="Date & Time")
    public Timestamp getFirstBindTime() {
        return this.firstBindTime;
    }

    @Property(viewable=false, order=51, category="Date & Time")
    public Timestamp getLastBindTime() {
        return this.lastBindTime;
    }

    @Property(viewable=false, order=52, category="Date & Time")
    public Timestamp getExplicitBindTime() {
        return this.explicitBindTime;
    }

    @Property(viewable=false, order=53, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, order=54, category="Date & Time")
    public Date getLastUsed() {
        return this.lastUsed;
    }
}

