/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLInformation;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class MySQLCollation
extends MySQLInformation {
    private MySQLCharset charset;
    private int id;
    private String name;
    private boolean isDefault;
    private boolean isCompiled;
    private int sortLength;

    public MySQLCollation(MySQLCharset charset, ResultSet dbResult) throws SQLException {
        super(charset.getDataSource());
        this.charset = charset;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATION");
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ID");
        this.isDefault = "Yes".equalsIgnoreCase(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFAULT"));
        this.isCompiled = "Yes".equalsIgnoreCase(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPILED"));
        this.sortLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SORTLEN");
    }

    @Property(viewable=true, order=1)
    public MySQLCharset getCharset() {
        return this.charset;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=3)
    public int getId() {
        return this.id;
    }

    @Property(viewable=true, order=4)
    public boolean isDefault() {
        return this.isDefault;
    }

    @Property(viewable=true, order=5)
    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Property(viewable=true, order=6)
    public int getSortLength() {
        return this.sortLength;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public DBSObject getParentObject() {
        return this.charset;
    }
}

