/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;

public final class ExasolTableCache
extends JDBCStructCache<ExasolSchema, ExasolTable, ExasolTableColumn> {
    private static final String SQL_COLS_TAB = "select \tc.* from \t\t \"$ODBCJDBC\".\"ALL_COLUMNS\" c where \ttable_schem = '%s' and \ttable_name = '%s' order by \tc.ordinal_position";
    private static final String SQL_COLS_ALL = "select \tc.* from \t\t \"$ODBCJDBC\".\"ALL_COLUMNS\" c where \ttable_schem = '%s'order by \ttable_name,c.ordinal_position";

    public ExasolTableCache() {
        super((Object)"TABLE_NAME");
    }

    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema) throws SQLException {
        JDBCDatabaseMetaData meta = session.getMetaData();
        return meta.getTables("EXA_DB", exasolSchema.getName(), null, new String[]{"TABLE"}).getSourceStatement();
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @Nullable ExasolTable exasolTable) throws SQLException {
        String sql = exasolTable != null ? String.format(SQL_COLS_TAB, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(exasolTable.getName())) : String.format(SQL_COLS_ALL, ExasolUtils.quoteString(exasolSchema.getName()));
        JDBCStatement dbstat = session.createStatement();
        ((JDBCStatementImpl)dbstat).setQueryString(sql);
        return dbstat;
    }

    protected ExasolTableColumn fetchChild(@NotNull JDBCSession session, @NotNull ExasolSchema owner, @NotNull ExasolTable parent, JDBCResultSet dbResult) throws SQLException, DBException {
        return new ExasolTableColumn(session.getProgressMonitor(), parent, (ResultSet)dbResult);
    }

    protected ExasolTable fetchObject(@NotNull JDBCSession session, @NotNull ExasolSchema owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        return new ExasolTable(session.getProgressMonitor(), owner, (ResultSet)resultSet);
    }
}

