/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.app;

import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.app.ExasolServerSession;
import org.jkiss.dbeaver.ext.exasol.model.app.ExasolServerSessionManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.utils.CommonUtils;

public class ExasolServerSessionEditor
extends AbstractSessionEditor {
    private KillSessionAction killSessionAction = new KillSessionAction(false);
    private KillSessionAction terminateQueryAction = new KillSessionAction(true);

    public void createEditorControl(Composite parent) {
        this.killSessionAction = new KillSessionAction(false);
        this.terminateQueryAction = new KillSessionAction(true);
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<ExasolServerSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new ExasolServerSessionManager((ExasolDataSource)executionContext.getDataSource())){

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)ExasolServerSessionEditor.this.killSessionAction);
                contributionManager.add((IAction)ExasolServerSessionEditor.this.terminateQueryAction);
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                ExasolServerSessionEditor.this.killSessionAction.setEnabled(session != null);
                ExasolServerSessionEditor.this.terminateQueryAction.setEnabled(session != null && !CommonUtils.isEmpty((String)session.getActiveQuery()));
            }
        };
    }

    private class KillSessionAction
    extends Action {
        private boolean killQuery;

        public KillSessionAction(boolean killQuery) {
            super(killQuery ? ExasolMessages.editors_exasol_session_editor_title_kill_session_statement : ExasolMessages.editors_exasol_session_editor_title_kill_session, killQuery ? UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP") : DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_DISCONNECT));
            this.killQuery = killQuery;
        }

        public void run() {
            DBAServerSession session = ExasolServerSessionEditor.this.getSessionsViewer().getSelectedSession();
            String action = ExasolMessages.editors_exasol_session_editor_action_kill;
            if (UIUtils.confirmAction((Shell)ExasolServerSessionEditor.this.getSite().getShell(), (String)"Confirm kill session", (String)NLS.bind((String)ExasolMessages.editors_exasol_session_editor_confirm_action, (Object)action.toLowerCase(), (Object)session))) {
                ExasolServerSessionEditor.this.getSessionsViewer().alterSession(ExasolServerSessionEditor.this.getSessionsViewer().getSelectedSession(), Collections.singletonMap("killQuery", this.killQuery));
            }
        }
    }
}

