/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.exec.MongoExecutionContext;
import com.dbeaver.ee.mongodb.model.MGDataType;
import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.dbeaver.ee.mongodb.model.MGOperationManager;
import com.dbeaver.ee.mongodb.model.MongoDataSourceInfo;
import com.dbeaver.ee.mongodb.model.MongoSQLDialect;
import com.mongodb.MongoSocketException;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.BasicObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class MongoDataSource
implements DBPDataSource,
SQLDataSource,
DBSObject,
DBSObjectSelector,
DBSObjectContainer,
DBPRefreshableObject,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(MongoDataSource.class);
    private DBPDataSourceContainer container;
    private MongoExecutionContext executionContext;
    private String selectedDatabase;
    private DatabaseCache databaseCache = new DatabaseCache();
    private MongoDataSourceInfo info;
    private List<MGDataType> dataTypes = new ArrayList<MGDataType>();

    public MongoDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        this.container = container;
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        this.selectedDatabase = connectionInfo.getDatabaseName();
        this.dataTypes.add(new MGDataType(this, 1, "ObjectId", "objectId"));
        this.dataTypes.add(new MGDataType(this, 2, "Document", "document"));
        this.dataTypes.add(new MGDataType(this, 3, "String", "string"));
        this.dataTypes.add(new MGDataType(this, 4, "Number", "number"));
        this.dataTypes.add(new MGDataType(this, 5, "Boolean", "boolean"));
        this.dataTypes.add(new MGDataType(this, 6, "Timestamp", "date"));
        this.dataTypes.add(new MGDataType(this, 7, "Binary", "byte[]"));
        this.dataTypes.add(new MGDataType(this, 8, "List", "array"));
        this.dataTypes.add(new MGDataType(this, 9, "Object", "object"));
        this.executionContext = new MongoExecutionContext(this, "Main Mongo Connection");
        this.executionContext.connect(monitor);
    }

    public MongoExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    @Association
    public Collection<MGDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public MGDatabase getDatabase(String name) {
        return (MGDatabase)this.databaseCache.getCachedObject(name);
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public MongoDataSource getDataSource() {
        return this;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return new DBCExecutionContext[]{this.executionContext};
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        MongoExecutionContext context = new MongoExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            this.databaseCache.getAllObjects(monitor, this);
            this.info = new MongoDataSourceInfo(this.executionContext.getClient());
        }
        catch (Exception e) {
            throw new DBException("Error initializing MongoDB context", (Throwable)e);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        this.initialize(monitor);
        return this;
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public String getSelectedDatabase() {
        return this.selectedDatabase;
    }

    public MGDatabase getDefaultObject() {
        return this.getDatabase(this.selectedDatabase);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        MGDatabase oldSelectedEntity = this.getDefaultObject();
        this.setActiveEntityName(object);
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return false;
    }

    void setActiveEntityName(DBSObject entity) throws DBException {
        if (entity instanceof MGDatabase) {
            this.selectedDatabase = entity.getName();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new MGOperationManager(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("cluster".equals(objectType)) {
            term = "Cluster";
        } else if ("keypace".equals(objectType)) {
            term = "Keyspace";
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        MongoDataSource mongoDataSource = this;
        synchronized (mongoDataSource) {
            this.executionContext.close();
        }
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    public SQLDialect getSQLDialect() {
        return MongoSQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getDatabase(childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return MGDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        switch (typeID) {
            case 1: {
                return DBPDataKind.ROWID;
            }
            case 2: {
                return DBPDataKind.DOCUMENT;
            }
            case 3: {
                return DBPDataKind.STRING;
            }
            case 4: {
                return DBPDataKind.NUMERIC;
            }
            case 5: {
                return DBPDataKind.BOOLEAN;
            }
            case 6: {
                return DBPDataKind.DATETIME;
            }
            case 7: {
                return DBPDataKind.BINARY;
            }
            case 8: {
                return DBPDataKind.ARRAY;
            }
        }
        return DBPDataKind.OBJECT;
    }

    public MGDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        MGDataType dataType = this.getLocalDataType(typeFullName);
        if (dataType == null || dataType.getTypeID() == 2) {
            return null;
        }
        return dataType;
    }

    public Collection<MGDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public MGDataType getLocalDataType(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    public DBSDataType getLocalDataType(int typeID) {
        for (MGDataType type : this.dataTypes) {
            if (type.getTypeID() != typeID) continue;
            return type;
        }
        return null;
    }

    public MGDataType getDataTypeByJS(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getJsName().equals(typeName)) continue;
            return type;
        }
        return this.getDataType(9);
    }

    public MGDataType getDataType(int valueType) {
        return this.dataTypes.get(valueType - 1);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "String";
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (error.getCause() instanceof MongoSocketException) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        return null;
    }

    class DatabaseCache
    extends BasicObjectCache<MongoDataSource, MGDatabase> {
        DatabaseCache() {
        }

        @NotNull
        public List<MGDatabase> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MongoDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGDatabase> databaseList = new ArrayList<MGDatabase>();
                try {
                    MongoIterable databaseNames = MongoDataSource.this.executionContext.getClient().listDatabaseNames();
                    for (String dbName : databaseNames) {
                        MGDatabase db = new MGDatabase(dataSource, dbName);
                        databaseList.add(db);
                    }
                }
                catch (Exception e) {
                    assert (dataSource != null);
                    databaseList.add(new MGDatabase(dataSource, dataSource.getContainer().getConnectionConfiguration().getDatabaseName()));
                }
                this.setCache(databaseList);
            }
            return this.getCachedObjects();
        }
    }
}

