/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.model.MGCollection;
import com.dbeaver.ee.mongodb.model.MGFunction;
import com.dbeaver.ee.mongodb.model.MGUser;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.BasicObjectCache;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class MGDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPSystemObject {
    private final MongoDataSource dataSource;
    private final String dbName;
    private final CollectionCache collectionCache = new CollectionCache();
    private final FunctionCache functionCache = new FunctionCache();
    private final UsersCache userCache = new UsersCache();
    private boolean persisted;

    public MGDatabase(MongoDataSource dataSource, String dbName) {
        this.dataSource = dataSource;
        this.dbName = dbName;
        this.persisted = true;
    }

    public CollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    @NotNull
    public MongoDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Association
    public Collection<MGCollection> getCollections(DBRProgressMonitor monitor) throws DBException {
        return this.collectionCache.getAllObjects(monitor, this);
    }

    public Collection<MGCollection> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.collectionCache.getAllObjects(monitor, this);
    }

    public MGCollection getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (MGCollection)this.collectionCache.getObject(monitor, (DBSObject)this, childName);
    }

    public Class<MGCollection> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return MGCollection.class;
    }

    @Association
    public Collection<MGFunction> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<MGUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, this);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.collectionCache.getAllObjects(monitor, this);
    }

    @NotNull
    public synchronized DB getDB() throws DBCException {
        MongoClient client = this.dataSource.getExecutionContext().getClient();
        if (client == null) {
            throw new DBCException("Not connected to Mongo");
        }
        return client.getDB(this.dbName);
    }

    @NotNull
    public synchronized MongoDatabase getDatabase() throws DBCException {
        MongoClient client = this.dataSource.getExecutionContext().getClient();
        if (client == null) {
            throw new DBCException("Not connected to Mongo");
        }
        return client.getDatabase(this.dbName);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return this.dbName.equals("admin") || this.dbName.equals("local");
    }

    class CollectionCache
    extends BasicObjectCache<MGDatabase, MGCollection> {
        CollectionCache() {
        }

        @NotNull
        public List<MGCollection> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDatabase mongoDatabase) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGCollection> tables = new ArrayList<MGCollection>();
                for (String colName : MGDatabase.this.getDB().getCollectionNames()) {
                    tables.add(new MGCollection(mongoDatabase, colName, true));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(tables);
            }
            return this.getCachedObjects();
        }
    }

    class FunctionCache
    extends BasicObjectCache<MGDatabase, MGFunction> {
        FunctionCache() {
        }

        @NotNull
        public List<MGFunction> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDatabase mongoDatabase) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGFunction> functions = new ArrayList<MGFunction>();
                MongoCollection jsCol = MGDatabase.this.getDatabase().getCollection("system.js", Document.class);
                for (Document jsObject : jsCol.find()) {
                    String name = (String)jsObject.get((Object)"_id");
                    Object value = jsObject.get((Object)"value");
                    functions.add(new MGFunction(mongoDatabase, true, name, CommonUtils.toString((Object)value)));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(functions);
            }
            return this.getCachedObjects();
        }
    }

    class UsersCache
    extends BasicObjectCache<MGDatabase, MGUser> {
        UsersCache() {
        }

        @NotNull
        public List<MGUser> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDatabase mongoDatabase) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGUser> functions = new ArrayList<MGUser>();
                MongoDatabase adminDB = MGDatabase.this.dataSource.getExecutionContext().getClient().getDatabase("admin");
                if (adminDB != null) {
                    MongoCollection usersCol = adminDB.getCollection("system.users", Document.class);
                    BasicDBObject dbCriteria = new BasicDBObject("db", (Object)MGDatabase.this.getName());
                    for (Document jsObject : usersCol.find((Bson)dbCriteria)) {
                        String name = (String)jsObject.get((Object)"user");
                        functions.add(new MGUser(mongoDatabase, name));
                        if (monitor.isCanceled()) break;
                    }
                    this.setCache(functions);
                }
            }
            return this.getCachedObjects();
        }
    }
}

