/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;

public class MongoResultSet
implements DBCResultSet,
DBRBlockingObject {
    private final MongoBaseStatement statement;
    private final DBCursor cursor;
    private final List<DBObject> list;
    private DBCResultSetMetaData metaData;
    private DBObject curRow;
    private long rowCount = 0L;

    public MongoResultSet(MongoBaseStatement statement, DBCursor cursor) {
        long limit;
        this.statement = statement;
        this.cursor = cursor;
        this.list = null;
        long offset = statement.getOffset();
        if (offset > 0L) {
            this.cursor.skip((int)offset);
        }
        if ((limit = statement.getLimit()) > 0L) {
            this.cursor.limit((int)limit);
        }
        QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        statement.getSession().getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoResultSet(MongoBaseStatement statement, List<DBObject> list) {
        this.statement = statement;
        this.cursor = null;
        this.list = list;
        QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        statement.getSession().getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoSession getSession() {
        return this.statement.getSession();
    }

    public MongoBaseStatement getSourceStatement() {
        return this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (this.list != null) {
            Iterator names = this.curRow.keySet().iterator();
            int i = 0;
            while (i < index) {
                if (!names.hasNext()) {
                    throw new DBCException("Index [" + index + "] out of bounds: " + this.curRow.keySet().size());
                }
                names.next();
                ++i;
            }
            return this.curRow.get((String)names.next());
        }
        if (index == 0) {
            return this.curRow;
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.curRow.get(name);
    }

    public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    public DBObject getCurRow() {
        return this.curRow;
    }

    public boolean nextRow() throws DBCException {
        if (this.list != null) {
            if ((long)this.list.size() > this.rowCount) {
                this.curRow = this.list.get((int)this.rowCount);
                ++this.rowCount;
                return true;
            }
            return false;
        }
        if (!this.cursor.hasNext()) {
            this.curRow = null;
            return false;
        }
        this.curRow = this.cursor.next();
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = this.cursor == null ? this.statement.createMetadata(this.list) : this.statement.createMetadata();
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public void close() {
        this.statement.getSession().getProgressMonitor().endBlock();
        QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, this.rowCount);
    }

    public void cancelBlock() throws DBException {
        this.cursor.close();
    }
}

