/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.data.MongoDocument;
import com.dbeaver.ee.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MongoInsertStatement
extends MongoBaseStatement {
    private DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public MongoInsertStatement(MongoSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session, MongoInsertStatement.makeQuery(mongoCollection, updateAttributes, rowValues));
        this.collection = mongoCollection;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            BasicDBObject o;
            if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                o = ((MongoDocument)((Object)this.rowValues[0])).getRootNode();
            } else {
                o = new BasicDBObject();
                int i = 0;
                while (i < this.valueAttributes.length) {
                    o.put(this.collection.getAttributeName(this.valueAttributes[i]), MongoUtils.unwrapMongoValue(this.valueAttributes[i], this.rowValues[i]));
                    ++i;
                }
            }
            this.writeResult = this.collection.getCollection().insert(new DBObject[]{o});
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO  ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i]));
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        sql.append(")");
        return sql.toString();
    }
}

