/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.edit;

import com.dbeaver.ee.mongodb.model.MGCollection;
import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.CommonUtils;

public class MongoCollectionManager
extends SQLObjectEditor<MGCollection, MGDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MGCollection> getObjectsCache(MGCollection object) {
        return object.getDatabase().getCollectionCache();
    }

    protected MGCollection createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final MGDatabase parent, Object copyFrom) {
        return (MGCollection)new UITask<MGCollection>(){

            protected MGCollection runTask() {
                String colName = EnterNameDialog.chooseName((Shell)UIUtils.getActiveWorkbenchShell(), (String)"Collection name");
                if (CommonUtils.isEmpty((String)colName)) {
                    return null;
                }
                return new MGCollection(parent, colName, false);
            }
        }.execute();
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, final SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Create collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                BasicDBObject colOptions = new BasicDBObject();
                collection.getDatabase().getDB().createCollection(collection.getName(), (DBObject)colOptions);
            }
        });
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, final SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Drop collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                collection.getCollection().drop();
            }
        });
    }
}

