/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mongodb.DBObject;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.impl.struct.AbstractDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.utils.CommonUtils;

public class MongoMapValue
extends AbstractDataType<MongoDataSource>
implements DBDComposite,
DBDValueCloneable {
    protected static Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ObjectId.class, (Object)new ObjectIdTypeConverter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().create();
    @Nullable
    private DBObject contents;
    @Nullable
    private Object parent;
    @NotNull
    private Map<String, Object> attributeValues;
    private transient String json;
    private boolean modified;

    public MongoMapValue(@NotNull MongoDataSource dataSource, @Nullable DBObject sourceData, @Nullable Object parent) {
        super((DBPDataSource)dataSource);
        this.parent = parent;
        this.updateContents(sourceData);
    }

    public DBObject getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    @NotNull
    public String getTypeName() {
        return "DBObject";
    }

    public int getTypeID() {
        return 2;
    }

    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    public DBSDataType getDataType() {
        return this;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.contents == null) {
            return new DBSAttributeBase[0];
        }
        Set keySet = this.contents.keySet();
        DBSAttributeBase[] attrs = new DBSAttributeBase[keySet.size()];
        int index = 0;
        for (String key : keySet) {
            attrs[index++] = new MapAttribute(index, key, this.contents.get(key));
        }
        return attrs;
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        return this.attributeValues.get(attribute.getName());
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) {
        if (this.contents != null) {
            this.contents.put(attribute.getName(), value);
        }
        this.attributeValues.put(attribute.getName(), DBUtils.getRawValue((Object)value));
        this.json = null;
        this.modified = true;
    }

    public MongoMapValue cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new MongoMapValue((MongoDataSource)this.getDataSource(), MongoUtils.cloneObject(this.contents), this.parent);
    }

    public String toJson() {
        if (this.json == null) {
            this.json = JSON_BUILDER.toJson((Object)this.contents);
        }
        return this.json;
    }

    void updateContents(@Nullable DBObject sourceData) {
        this.contents = sourceData;
        this.attributeValues = new LinkedHashMap<String, Object>();
        if (this.contents != null) {
            for (String key : this.contents.keySet()) {
                Object value = MongoUtils.wrapMongoValue((MongoDataSource)this.getDataSource(), this.contents.get(key), (Object)this);
                this.attributeValues.put(key, value);
            }
        }
        this.json = null;
        this.modified = true;
    }

    public static class ISODateTypeConverter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(JSONUtils.formatISODate((Date)src));
        }

        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return JSONUtils.parseDate((String)json.getAsString());
        }
    }

    private class MapAttribute
    extends AbstractAttribute
    implements DBSAttributeBase {
        MapAttribute(int index, String name, Object value) {
            int valueType = MongoMapValue.this.parent == null && name.equals("_id") ? 1 : MongoUtils.resolveValueType(value);
            this.setValueType(valueType);
            this.setName(name);
            this.setOrdinalPosition(index);
            this.setTypeName(((MongoDataSource)MongoMapValue.this.getDataSource()).getDataType(valueType).getName());
        }

        public DBPDataKind getDataKind() {
            return ((MongoDataSource)MongoMapValue.this.getDataSource()).resolveDataKind("map", this.valueType);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapAttribute)) {
                return false;
            }
            MapAttribute attr = (MapAttribute)((Object)obj);
            return CommonUtils.equalObjects((Object)this.name, (Object)attr.name) && this.valueType == attr.valueType && this.maxLength == attr.maxLength && CommonUtils.equalObjects((Object)this.scale, (Object)attr.scale) && CommonUtils.equalObjects((Object)this.precision, (Object)attr.precision) && CommonUtils.equalObjects((Object)this.typeName, (Object)attr.typeName) && this.ordinalPosition == attr.ordinalPosition;
        }

        public int hashCode() {
            return (int)((long)(this.name.hashCode() + this.valueType) + this.maxLength + (long)this.scale.intValue() + (long)this.precision.intValue() + (long)this.typeName.hashCode() + (long)this.ordinalPosition);
        }
    }

    public static class ObjectIdTypeConverter
    implements JsonSerializer<ObjectId>,
    JsonDeserializer<ObjectId> {
        public JsonElement serialize(ObjectId src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public ObjectId deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return new ObjectId(json.getAsString());
        }
    }
}

