/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IErrorResult;
import com.vertica.dsi.dataengine.interfaces.IRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IStreamQueryExecutor;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.BadDefaultParamException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SParameterMetaData;
import com.vertica.jdbc.common.SResultSetMetaData;
import com.vertica.jdbc.common.SStatement;
import com.vertica.streams.parameters.AbstractParameterStream;
import com.vertica.streams.parameters.AsciiParameterStream;
import com.vertica.streams.parameters.BinaryParameterStream;
import com.vertica.streams.parameters.CharacterParameterStream;
import com.vertica.streams.parameters.UnicodeParameterStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.ReferenceEqualityWrapper;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SPreparedStatement
extends SStatement
implements PreparedStatement {
    private static final Map<Integer, Set<Integer>> s_stringRepCompatibilityLookup = SPreparedStatement.initializeStringRepCompatibilityLookup();
    protected ArrayList<ParameterMetadata> m_parameterMetadata = new ArrayList();
    protected int m_numParameters;
    protected List<ParameterType> m_parameterTypes;
    protected Map<Integer, ParameterInputValue> m_parameterInputValues = new TreeMap<Integer, ParameterInputValue>();
    protected Map<Integer, AbstractParameterStream> m_parameterInputStreams = new TreeMap<Integer, AbstractParameterStream>();
    protected boolean m_hasParameterBatch = false;
    protected List<Map<Integer, ParameterInputValue>> m_batchParameterInputValues = new ArrayList<Map<Integer, ParameterInputValue>>();
    protected List<Map<Integer, AbstractParameterStream>> m_batchParameterInputStreams = new ArrayList<Map<Integer, AbstractParameterStream>>();
    protected String m_preparedSql = "";
    protected SResultSetMetaData m_metadata = null;
    protected SParameterMetaData m_openParamMetaData = null;
    private List<DataWrapper> m_cachedDataWrappers = null;
    private boolean m_supportStreamingBatches = false;
    private HashSet<ReferenceEqualityWrapper> m_currExecutionStreamSet = new HashSet();
    private HashSet<ReferenceEqualityWrapper> m_lastStreamsExecuted = new HashSet();
    private int m_nextParamSetForStream = 0;

    protected SPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(iStatement, sConnection, n);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, iStatement, sConnection);
            this.m_preparedSql = string;
            this.checkIfNullSQL(string);
            IDataEngine iDataEngine = this.m_statement.createDataEngine();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = sConnection.nativeSQL(string);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.m_queryExecutor = iDataEngine.prepare(string);
            iDataEngine.close();
            this.m_parameterMetadata = this.m_queryExecutor.getMetadataForParameters();
            if (null == this.m_parameterMetadata) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_PARAM_METADATA, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_numParameters = this.m_parameterMetadata.size();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>(this.m_numParameters);
            this.m_parameterTypes = new ArrayList<ParameterType>(this.m_numParameters);
            boolean bl = true;
            for (int i = 0; i < this.m_numParameters; ++i) {
                ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(i);
                if (bl && parameterMetadata.getTypeMetadata().isCharacterOrBinaryType()) {
                    bl = false;
                    this.m_parentConnection.setMaxTypeValues();
                }
                this.m_parameterTypes.add(parameterMetadata.getParameterType());
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
            this.checkParameters(this.m_parameterMetadata);
            this.clearParameters();
            if (this.m_parentConnection.getConnection().getProperty(1006).getString().equals("Y")) {
                if (!(this.m_queryExecutor instanceof IStreamQueryExecutor)) {
                    this.getLogger().logWarning("com.vertica.jdbc.common", "SPreparedStatement", "SPreparedStatement", "ConnPropertyKey.DSI_SUPPORTS_STREAMED_BATCH_PREPARED_STMTS is set to 'Y', but IStreamQueryExecutor interface is not implemented. Batched parameters will not be streamed.");
                } else {
                    this.m_supportStreamingBatches = true;
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_cachedDataWrappers.clear();
            for (int i = 0; i < this.m_numParameters; ++i) {
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
            this.m_hasParameterBatch = true;
            if (!this.m_supportStreamingBatches) {
                this.m_batchParameterInputValues.add(this.m_parameterInputValues);
                this.m_batchParameterInputStreams.add(this.m_parameterInputStreams);
                this.m_parameterInputValues = new TreeMap<Integer, ParameterInputValue>(this.m_parameterInputValues);
                this.m_parameterInputStreams = new TreeMap<Integer, AbstractParameterStream>();
            } else {
                IStreamQueryExecutor iStreamQueryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                if (0 == this.m_nextParamSetForStream) {
                    this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                    iStreamQueryExecutor.clearCancel();
                    this.m_parentConnection.beginTransaction();
                    this.clearResults();
                    ++this.m_nextParamSetForStream;
                }
                iStreamQueryExecutor.startParamSet(this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreams), this.m_warningListener);
                this.pushClearSingleBatchSetStreams();
                iStreamQueryExecutor.finalizeParamSet(this.m_warningListener);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void checkValidParameterIndex(int n) throws SQLException {
        if (1 > n || this.m_numParameters < n) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            for (int i = 0; i < this.m_batchParameterInputValues.size(); ++i) {
                this.clearParameters(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreams.get(i));
            }
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreams);
            if (null != this.m_queryExecutor) {
                if (this.m_supportStreamingBatches) {
                    IStreamQueryExecutor iStreamQueryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                    this.m_nextParamSetForStream = 0;
                    iStreamQueryExecutor.clearBatch();
                } else {
                    this.m_queryExecutor.clearPushedParamData();
                    this.m_batchParameterInputStreams.clear();
                    this.m_batchParameterInputValues.clear();
                }
            }
            this.m_hasParameterBatch = false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreams);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
        if (null != this.m_queryExecutor) {
            this.m_queryExecutor.close();
            this.m_queryExecutor = null;
        }
        if (null != this.m_metadata) {
            this.m_metadata = null;
        }
        if (null != this.m_openParamMetaData) {
            this.m_openParamMetaData.close();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            ExecutionResults executionResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), SStatement.ThrowCondition.None);
            if (0 == executionResults.getResults().size()) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < executionResults.getResults().size(); ++i) {
                ExecutionResult executionResult = executionResults.getResults().get(i);
                if (0 == i) {
                    bl = ExecutionResultType.RESULT_SET == executionResult.getType() || ExecutionResultType.ERROR_RESULT_SET == executionResult.getType();
                }
                this.addResultPair(this.createResultPair(executionResult));
            }
            SStatement.ResultContext resultContext = (SStatement.ResultContext)this.m_resultSets.get(0);
            if (2 == resultContext.m_resultType || 3 == resultContext.m_resultType) {
                throw ((IErrorResult)resultContext.m_result).getError();
            }
            return bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            if (!this.m_supportStreamingBatches) {
                this.m_queryExecutor.clearCancel();
                this.m_parentConnection.beginTransaction();
                this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                    this.clearResults();
                    this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                    object = new int[0];
                    return object;
                }
                this.pushBatchParameterStreams();
                ExecutionContexts executionContexts = new ExecutionContexts(this.m_parameterMetadata, this.getBatchInputParameterValues());
                this.clearResults();
                object = this.m_cancelLock;
                synchronized (object) {
                    if (this.m_isCanceled) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                }
                this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            } else {
                this.m_currExecutionStreamSet.clear();
                this.m_queryExecutor.finalizePushedParamData();
                object = (IStreamQueryExecutor)this.m_queryExecutor;
                if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                    this.clearResults();
                    this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                    int[] nArray = new int[]{};
                    return nArray;
                }
                Object object2 = this.m_cancelLock;
                synchronized (object2) {
                    if (this.m_isCanceled) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                }
                object.execute(this.m_warningListener);
            }
            object = this.processBatchResults(this.m_queryExecutor.getResults());
            return object;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
            this.clearBatch();
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            ExecutionResults executionResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), SStatement.ThrowCondition.SingleResult);
            ExecutionResult executionResult = executionResults.getResults().get(0);
            if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            ResultSet resultSet = this.createResultSet(executionResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            return resultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            ExecutionResults executionResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), SStatement.ThrowCondition.SingleRowCount);
            ExecutionResult executionResult = executionResults.getResults().get(0);
            if (ExecutionResultType.ERROR_ROW_COUNT == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            this.addResultPair(this.createResultPair(executionResult));
            if (iRowCountResult.hasRowCount()) {
                return (int)iRowCountResult.getRowCount();
            }
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected SParameterMetaData getOpenParamMetaData() {
        return this.m_openParamMetaData;
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public SResultSetMetaData getResultSetMetaData() {
        return this.m_metadata;
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    protected ArrayList<ParameterMetadata> getParameterMetadataList() {
        return this.m_parameterMetadata;
    }

    @Override
    public synchronized void setArray(int n, Array array) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, array);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, typeMetadata.getType());
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, n2, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bigDecimal);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == bigDecimal) {
                this.setNull(n, 2);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setNumeric(bigDecimal);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-4, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, typeMetadata.getType());
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, n2, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, blob);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bl);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setBoolean(bl);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setByte(int n, byte by) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, by);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setTinyInt(by);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, byArray);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == byArray) {
                dataWrapper.setNull(-3);
            } else if (byArray.length > this.m_parentConnection.m_maxVarbinarySize) {
                dataWrapper.setLongVarBinary(byArray);
            } else {
                dataWrapper.setVarBinary(byArray);
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, reader, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == reader) {
                this.setNull(n, typeMetadata.getType());
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, (long)n2, parameterMetadata, (int)typeMetadata.getType());
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setClob(int n, Clob clob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clob);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int n, Date date) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, date);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == date) {
                this.setNull(n, 91);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setDate(date);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, date);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        try {
            if (null == calendar || null == date) {
                this.setDate(n, date);
            } else {
                calendar.clear();
                calendar.setTimeInMillis(date.getTime());
                Calendar calendar2 = Calendar.getInstance();
                calendar2.clear();
                calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                calendar2.set(14, 0);
                this.setDate(n, new Date(calendar2.getTimeInMillis()));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDouble(int n, double d) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, d);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setDouble(d);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFloat(int n, float f) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, Float.valueOf(f));
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setReal(f);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setInt(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setInteger(n2);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLong(int n, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setBigInt(BigInteger.valueOf(l));
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            this.checkTypeSupported(n2);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            if (Nullable.NULLABLE != parameterMetadata.getNullable()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_NOT_NULLABLE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (0 == n2) {
                dataWrapper.setNull(parameterMetadata.getTypeMetadata().getType());
            } else {
                dataWrapper.setNull(n2);
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, string);
        this.setNull(n, n2);
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            short s = parameterMetadata.getTypeMetadata().getType();
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == object) {
                dataWrapper.setNull(s);
            } else {
                try {
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType(dataWrapper2, parameterMetadata.getTypeMetadata(), (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
                }
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
        this.setObject(n, object, n2, 0);
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block11: {
            try {
                LogUtilities.logFunctionEntrance(this.getLogger(), n, object, n2, n3);
                this.checkIfOpen();
                this.checkValidParameterIndex(n);
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                if (null == object) {
                    this.setNull(n, n2);
                    break block11;
                }
                if (0 == n2) {
                    ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
                    this.setNull(n, parameterMetadata.getTypeMetadata().getType());
                    break block11;
                }
                try {
                    ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
                    int n4 = TypeConverter.getSqlType(object);
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(n4, object);
                    if (n2 != n4) {
                        dataWrapper2 = TypeConverter.toType(dataWrapper2, n2, (IWarningListener)this.getWarningListener());
                    }
                    switch (n2) {
                        case 2: {
                            dataWrapper2.setNumeric(dataWrapper2.getNumeric().setScale(n3, 4));
                            break;
                        }
                        case 3: {
                            dataWrapper2.setDecimal(dataWrapper2.getDecimal().setScale(n3, 4));
                            break;
                        }
                    }
                    dataWrapper = TypeConverter.toType(dataWrapper2, parameterMetadata.getTypeMetadata(), (IWarningListener)this.getWarningListener());
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(object));
                }
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
            }
        }
    }

    public void setResultSetMetadata(SResultSetMetaData sResultSetMetaData) {
        this.m_metadata = sResultSetMetaData;
    }

    protected void setOpenParamMetaData(SParameterMetaData sParameterMetaData) {
        this.m_openParamMetaData = sParameterMetaData;
    }

    @Override
    public synchronized void setRef(int n, Ref ref) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, ref);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setShort(int n, short s) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, s);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setSmallInt(s);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setString(int n, String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, string);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == string) {
                dataWrapper.setNull(12);
            } else if (string.length() > this.m_parentConnection.m_maxVarcharSize) {
                dataWrapper.setLongVarChar(string);
            } else {
                dataWrapper.setVarChar(string);
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int n, Time time) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == time) {
                this.setNull(n, 92);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTime(time);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == time) {
                this.setNull(n, 92);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTime(new TimeTz(time, calendar));
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == timestamp) {
                this.setNull(n, 93);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTimestamp(timestamp);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp, calendar);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == timestamp) {
                this.setNull(n, 93);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, typeMetadata.getType());
            } else {
                UnicodeParameterStream unicodeParameterStream = new UnicodeParameterStream(inputStream, n2, parameterMetadata, (int)typeMetadata.getType());
                this.setParameterInputStream(n, unicodeParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setURL(int n, URL uRL) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, uRL);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    void closeIfPrepared() throws SQLException {
        this.close();
    }

    protected boolean allInputParameterValuesPopulated() {
        return this.m_parameterInputStreams.size() + this.m_parameterInputValues.size() == this.m_numParameters;
    }

    protected void checkParameters(List<ParameterMetadata> list) throws SQLException {
        for (int i = 0; i < list.size(); ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INPUT_ONLY, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(list.get(i).getParameterNumber()));
        }
    }

    protected void checkTypeSupported(int n) throws SQLException {
        switch (n) {
            case -11: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        }
    }

    protected void clearParameters(Map<Integer, ParameterInputValue> map, Map<Integer, AbstractParameterStream> map2) {
        map.clear();
        for (AbstractParameterStream abstractParameterStream : map2.values()) {
            if (null == abstractParameterStream) continue;
            this.m_lastStreamsExecuted.remove(abstractParameterStream.getEqualityStreamWrapper());
            abstractParameterStream.close();
        }
        map2.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutionResults executeWithParams(ArrayList<ParameterMetadata> arrayList, ArrayList<ArrayList<ParameterInputValue>> arrayList2, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.checkCondition(this.m_preparedSql, throwCondition);
            object = new ExecutionContexts(arrayList, arrayList2);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute((ExecutionContexts)object, this.m_warningListener);
            this.m_metadata = null;
            object2 = this.m_queryExecutor.getResults();
            return object2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
        }
    }

    private void createAndSetParameterInputValue(int n, DataWrapper dataWrapper) throws SQLException {
        ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(--n);
        if (ParameterType.OUTPUT == this.m_parameterTypes.get(n)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
        }
        ParameterInputValue parameterInputValue = this.createParameterInputValue(dataWrapper, parameterMetadata);
        Integer n2 = n + 1;
        AbstractParameterStream abstractParameterStream = this.m_parameterInputStreams.get(n2);
        if (null != abstractParameterStream) {
            this.m_lastStreamsExecuted.remove(abstractParameterStream.getEqualityStreamWrapper());
            abstractParameterStream.close();
            this.m_parameterInputStreams.remove(n2);
        }
        this.m_parameterInputValues.put(n2, parameterInputValue);
    }

    private DataWrapper ConvertValueToTypeAsString(DataWrapper dataWrapper, TypeMetadata typeMetadata) throws IncorrectTypeException, SQLException {
        if (TypeUtilities.isCharacterType(dataWrapper.getType())) {
            return dataWrapper;
        }
        if (!this.stringRepresentationsCompatible(dataWrapper.getType(), typeMetadata.getType())) {
            dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
        }
        dataWrapper.setVarChar(TypeConverter.toString(dataWrapper, typeMetadata));
        return dataWrapper;
    }

    private ParameterInputValue createParameterInputValue(DataWrapper dataWrapper, ParameterMetadata parameterMetadata) throws SQLException {
        assert (null != dataWrapper);
        assert (null != parameterMetadata);
        try {
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (parameterMetadata.shouldConvertInputToString()) {
                dataWrapper = this.ConvertValueToTypeAsString(dataWrapper, typeMetadata);
            } else if (dataWrapper.getType() != typeMetadata.getType()) {
                dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
            }
            return new ParameterInputValue(parameterMetadata, dataWrapper);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERSION_ERROR_INPUT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
        }
    }

    private ArrayList<ArrayList<ParameterInputValue>> getBatchInputParameterValues() {
        int n = this.m_batchParameterInputValues.size();
        ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>(n);
        for (int i = 0; i < n; ++i) {
            ArrayList<ParameterInputValue> arrayList2 = this.getInputParameterValues(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreams.get(i));
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private ArrayList<ArrayList<ParameterInputValue>> getInputParameterValues() {
        ArrayList<ParameterInputValue> arrayList = this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreams);
        ArrayList<ArrayList<ParameterInputValue>> arrayList2 = new ArrayList<ArrayList<ParameterInputValue>>(1);
        arrayList2.add(arrayList);
        return arrayList2;
    }

    private ArrayList<ParameterInputValue> getInputParameterValues(Map<Integer, ParameterInputValue> map, Map<Integer, AbstractParameterStream> map2) {
        ArrayList<ParameterInputValue> arrayList = new ArrayList<ParameterInputValue>(this.m_numParameters);
        for (int i = 0; i < this.m_numParameters; ++i) {
            if (ParameterType.OUTPUT == this.m_parameterTypes.get(i) || ParameterType.RETURN_VALUE == this.m_parameterTypes.get(i)) continue;
            Integer n = i + 1;
            if (map.containsKey(n)) {
                arrayList.add(map.get(n));
                continue;
            }
            AbstractParameterStream abstractParameterStream = map2.get(n);
            arrayList.add(new ParameterInputValue(abstractParameterStream.getMetadata(), true, null));
        }
        return arrayList;
    }

    private void pushBatchParameterStreams() throws SQLException {
        try {
            int n = this.m_batchParameterInputStreams.size();
            for (int i = 0; i < n; ++i) {
                this.pushParameterStreams(i + 1, this.m_batchParameterInputStreams.get(i));
            }
            this.m_queryExecutor.finalizePushedParamData();
            this.m_currExecutionStreamSet.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void pushParameterStreams() throws SQLException {
        try {
            this.pushParameterStreams(1, this.m_parameterInputStreams);
            this.m_queryExecutor.finalizePushedParamData();
            this.m_currExecutionStreamSet.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void pushClearSingleBatchSetStreams() throws SQLException {
        try {
            for (AbstractParameterStream abstractParameterStream : this.m_parameterInputStreams.values()) {
                if (!this.m_currExecutionStreamSet.add(abstractParameterStream.getEqualityStreamWrapper())) {
                    this.m_currExecutionStreamSet.clear();
                    throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
                }
                while (abstractParameterStream.hasMoreData()) {
                    this.m_queryExecutor.pushParamData(this.m_nextParamSetForStream, abstractParameterStream.getNextValue());
                }
                this.m_lastStreamsExecuted.remove(abstractParameterStream.getEqualityStreamWrapper());
                abstractParameterStream.close();
            }
            this.m_parameterInputStreams.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
        finally {
            ++this.m_nextParamSetForStream;
        }
    }

    private void pushParameterStreams(int n, Map<Integer, AbstractParameterStream> map) throws ErrorException, IOException, BadDefaultParamException {
        for (AbstractParameterStream abstractParameterStream : map.values()) {
            if (!this.m_currExecutionStreamSet.add(abstractParameterStream.getEqualityStreamWrapper())) {
                this.m_currExecutionStreamSet.clear();
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.m_lastStreamsExecuted.add(abstractParameterStream.getEqualityStreamWrapper());
            while (abstractParameterStream.hasMoreData()) {
                this.m_queryExecutor.pushParamData(n, abstractParameterStream.getNextValue());
            }
        }
    }

    public void setParameterInputStream(int n, AbstractParameterStream abstractParameterStream) throws SQLException {
        ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
        if (ParameterType.OUTPUT == parameterMetadata.getParameterType()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SET_TYPE, (IWarningListener)this.getWarningListener(), ExceptionType.DATA, String.valueOf(n));
        }
        this.m_parameterInputValues.remove(n);
        AbstractParameterStream abstractParameterStream2 = this.m_parameterInputStreams.get(n);
        if (null != abstractParameterStream2) {
            this.m_lastStreamsExecuted.remove(abstractParameterStream2.getEqualityStreamWrapper());
            abstractParameterStream2.close();
        }
        this.m_parameterInputStreams.put(n, abstractParameterStream);
    }

    private boolean stringRepresentationsCompatible(int n, int n2) {
        Set<Integer> set = s_stringRepCompatibilityLookup.get(n);
        if (null == set) {
            return false;
        }
        return set.contains(n2);
    }

    private static Map<Integer, Set<Integer>> initializeStringRepCompatibilityLookup() {
        List<Integer> list = Arrays.asList(1, 12, -1, -8, -9, -10);
        HashMap<Integer, Set<Integer>> hashMap = new HashMap<Integer, Set<Integer>>();
        for (Integer n : TypeUtilities.getSupportedSqlTypes()) {
            HashSet<Integer> hashSet = new HashSet<Integer>(list);
            hashSet.add(n);
            for (Integer n2 : TypeUtilities.getSupportedSqlTypes()) {
                if ((!TypeUtilities.isBinaryType(n) || !TypeUtilities.isBinaryType(n2)) && (!TypeUtilities.isIntegerType(n) || !TypeUtilities.isIntegerType(n2) && !TypeUtilities.isNumberType(n2)) && (!TypeUtilities.isApproximateNumericType(n) && !TypeUtilities.isExactNumericType(n) || !TypeUtilities.isApproximateNumericType(n2) && !TypeUtilities.isExactNumericType(n2)) && (-7 != n && 16 != n || -7 != n2 && 16 != n2)) continue;
                hashSet.add(n2);
            }
            hashMap.put(n, hashSet);
        }
        return hashMap;
    }
}

