/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import com.dbeaver.ee.mockdata.adv.generator.NumericAdvancedGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringAddressGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringCityGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringCountryGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringDomainGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringEmailGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringNameGenerator;
import com.dbeaver.ee.mockdata.adv.generator.StringRegexGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractStringValueGenerator;
import org.jkiss.dbeaver.ext.mockdata.generator.ConstantGenerator;
import org.jkiss.dbeaver.ext.mockdata.generator.NumericSequenceGenerator;
import org.jkiss.dbeaver.ext.mockdata.model.MockValueGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class StringTemplateGenerator
extends AbstractStringValueGenerator {
    private static final Log log = Log.getLog(StringTemplateGenerator.class);
    private String template;
    private List<MockValueGenerator> generatorsSequence = new ArrayList<MockValueGenerator>();

    public void init(DBSDataManipulator dBSDataManipulator, DBSAttributeBase dBSAttributeBase, Map<Object, Object> map) throws DBException {
        String[] stringArray;
        super.init(dBSDataManipulator, dBSAttributeBase, map);
        String string = (String)map.get("template");
        if (!CommonUtils.isEmpty((String)string)) {
            this.template = string;
        }
        String[] stringArray2 = stringArray = CommonUtils.splitWithDelimiter((String)this.template, (String)"${");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block37: {
                boolean bl;
                String string2;
                block38: {
                    String string3;
                    boolean bl2;
                    int n3;
                    string2 = stringArray2[n2];
                    if (CommonUtils.isEmpty((String)string2)) break block37;
                    bl = true;
                    if (!string2.startsWith("${") || (n3 = string2.lastIndexOf(125)) <= 0) break block38;
                    String string4 = string2.substring(2, n3);
                    int n4 = string4.indexOf(40);
                    int n5 = string4.lastIndexOf(41);
                    boolean bl3 = bl2 = n4 > 0 && n5 > n4;
                    if (!bl2) break block38;
                    try {
                        String[] stringArray3 = string4.substring(n4 + 1, n5).split(",");
                        switch (string3 = string4.substring(0, n4)) {
                            case "address": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringAddressGenerator(), dBSDataManipulator, new Object[0]));
                                break;
                            }
                            case "city": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringCityGenerator(), dBSDataManipulator, new Object[0]));
                                break;
                            }
                            case "country": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringCountryGenerator(), dBSDataManipulator, new Object[0]));
                                break;
                            }
                            case "domain": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringDomainGenerator(), dBSDataManipulator, new Object[0]));
                                break;
                            }
                            case "email": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringEmailGenerator(), dBSDataManipulator, "gender", stringArray3[0], "withSurnames", stringArray3[1], "numericSuffixSize", 0));
                                break;
                            }
                            case "name": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringNameGenerator(), dBSDataManipulator, "gender", stringArray3[0], "withSurnames", stringArray3[1]));
                                break;
                            }
                            case "random": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new NumericAdvancedGenerator(), dBSDataManipulator, "minimum", stringArray3[0], "maximum", stringArray3[1], "precision", 10, "scale", 0));
                                break;
                            }
                            case "regex": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new StringRegexGenerator(), dBSDataManipulator, "regex", stringArray3[0]));
                                break;
                            }
                            case "sequence": {
                                this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new NumericSequenceGenerator(), dBSDataManipulator, "start", stringArray3[0], "step", stringArray3[1]));
                            }
                        }
                        String string5 = string2.substring(n3 + 1);
                        if (!CommonUtils.isEmpty((String)string5)) {
                            this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new ConstantGenerator(), dBSDataManipulator, "value", string5));
                        }
                        bl = false;
                    }
                    catch (Exception exception) {
                        string3 = "Error of the \"" + string2 + "\" directive of the \"" + string + "\" template processing.";
                        log.error((Object)string3, (Throwable)exception);
                        throw new DBException(string3);
                    }
                }
                if (bl) {
                    this.generatorsSequence.add(this.initGenerator((MockValueGenerator)new ConstantGenerator(), dBSDataManipulator, "value", string2));
                }
            }
            ++n2;
        }
    }

    protected Object generateOneValue(DBRProgressMonitor dBRProgressMonitor) throws DBException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (MockValueGenerator mockValueGenerator : this.generatorsSequence) {
            stringBuilder.append(mockValueGenerator.generateValue(dBRProgressMonitor));
        }
        return stringBuilder.toString();
    }

    private MockValueGenerator initGenerator(MockValueGenerator mockValueGenerator, DBSDataManipulator dBSDataManipulator, Object ... objectArray) throws DBException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = iterator.next();
            hashMap.put(object, object2);
        }
        hashMap.put("nulls", 0);
        mockValueGenerator.init(dBSDataManipulator, this.attribute, hashMap);
        return mockValueGenerator;
    }
}

