/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class WizardPrefPage
extends WizardPage
implements ICompositeDialogPage {
    private final IPreferencePage preferencePage;
    private final List<WizardPrefPage> subPages = new ArrayList<WizardPrefPage>();

    public WizardPrefPage(IPreferencePage preferencePage, String title, String description) {
        super(preferencePage.getTitle());
        this.preferencePage = preferencePage;
        this.setTitle(title);
        this.setDescription(description);
    }

    public boolean isPageComplete() {
        return this.getControl() == null || this.preferencePage.isValid();
    }

    public void createControl(Composite parent) {
        if (this.preferencePage instanceof AbstractPrefPage) {
            ((AbstractPrefPage)this.preferencePage).disableButtons();
        }
        this.preferencePage.createControl(parent);
    }

    public void dispose() {
        this.preferencePage.dispose();
        super.dispose();
    }

    public Control getControl() {
        return this.preferencePage.getControl();
    }

    public String getDescription() {
        if (!CommonUtils.isEmpty((String)this.preferencePage.getDescription())) {
            return this.preferencePage.getDescription();
        }
        return super.getDescription();
    }

    public String getErrorMessage() {
        return this.preferencePage.getErrorMessage();
    }

    public Image getImage() {
        return this.preferencePage.getImage();
    }

    public String getMessage() {
        return this.preferencePage.getMessage();
    }

    public String getTitle() {
        if (!CommonUtils.isEmpty((String)this.preferencePage.getTitle())) {
            return this.preferencePage.getTitle();
        }
        return super.getTitle();
    }

    public void performHelp() {
        this.preferencePage.performHelp();
    }

    public void setVisible(boolean visible) {
        this.preferencePage.setVisible(visible);
    }

    public void performFinish() {
        this.preferencePage.performOk();
    }

    public void performCancel() {
        this.preferencePage.performCancel();
    }

    public WizardPrefPage[] getSubPages() {
        if (this.subPages.isEmpty()) {
            return null;
        }
        return this.subPages.toArray(new WizardPrefPage[this.subPages.size()]);
    }

    public void addSubPage(IPreferencePage page, String title, String description) {
        this.subPages.add(new WizardPrefPage(page, title, description));
        if (this.preferencePage instanceof IWorkbenchPropertyPage && page instanceof IWorkbenchPropertyPage) {
            ((IWorkbenchPropertyPage)page).setElement(((IWorkbenchPropertyPage)this.preferencePage).getElement());
        }
    }
}

