/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.utils.CommonUtils;

public abstract class NavigatorViewBase
extends ViewPart
implements INavigatorModelView,
IDataSourceContainerProvider {
    private DBNModel model = DBeaverCore.getInstance().getNavigatorModel();
    private DatabaseNavigatorTree tree;
    private transient Object lastSelection;

    protected NavigatorViewBase() {
    }

    public DBNModel getModel() {
        return this.model;
    }

    protected DatabaseNavigatorTree getNavigatorTree() {
        return this.tree;
    }

    protected IFilter getNavigatorFilter() {
        return null;
    }

    @NotNull
    public TreeViewer getNavigatorViewer() {
        return this.tree.getViewer();
    }

    public void createPartControl(Composite parent) {
        this.tree = this.createNavigatorTree(parent, this.getRootNode());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tree.getViewer());
    }

    private DatabaseNavigatorTree createNavigatorTree(Composite parent, DBNNode rootNode) {
        DatabaseNavigatorTree navigatorTree = new DatabaseNavigatorTree(parent, rootNode, this.getTreeStyle(), false, this.getNavigatorFilter());
        navigatorTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NavigatorViewBase.this.onSelectionChange((IStructuredSelection)event.getSelection());
            }
        });
        navigatorTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewer viewer = NavigatorViewBase.this.tree.getViewer();
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object node = objectArray[n2];
                    if (node instanceof DBNResource && ((DBNResource)node).getResource() instanceof IFolder) {
                        NavigatorViewBase.this.toggleNode(viewer, node);
                    } else if (node instanceof DBNDataSource) {
                        DoubleClickBehavior dsBehaviorDefault = DoubleClickBehavior.valueOf(DBeaverCore.getGlobalPreferenceStore().getString("navigator.connection.doubleClick"));
                        if (dsBehaviorDefault == DoubleClickBehavior.EXPAND) {
                            NavigatorViewBase.this.toggleNode(viewer, node);
                        } else {
                            DBPDataSourceContainer dataSource = ((DBNDataSource)node).getObject();
                            DoubleClickBehavior doubleClickBehavior = DoubleClickBehavior.valueOf(DBeaverCore.getGlobalPreferenceStore().getString("navigator.connection.doubleClick"));
                            switch (doubleClickBehavior) {
                                case EDIT: {
                                    NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)((DBNDataSource)node), null, UIUtils.getActiveWorkbenchWindow());
                                    break;
                                }
                                case CONNECT: {
                                    if (dataSource.isConnected()) {
                                        DataSourceHandler.disconnectDataSource(dataSource, null);
                                        break;
                                    }
                                    DataSourceHandler.connectToDataSource(null, dataSource, null);
                                    break;
                                }
                                case SQL_EDITOR: {
                                    try {
                                        OpenHandler.openRecentScript(NavigatorViewBase.this.getSite().getWorkbenchWindow(), dataSource, null);
                                        break;
                                    }
                                    catch (CoreException e) {
                                        DBUserInterface.getInstance().showError("Open SQL editor", "Can't open SQL editor", (Throwable)e);
                                    }
                                }
                            }
                        }
                    } else {
                        boolean hasChildren;
                        DoubleClickBehavior dcBehaviorDefault = DoubleClickBehavior.valueOf(DBeaverCore.getGlobalPreferenceStore().getString("navigator.object.doubleClick"));
                        boolean bl = hasChildren = node instanceof DBNNode && ((DBNNode)node).hasChildren(true);
                        if (hasChildren && dcBehaviorDefault == DoubleClickBehavior.EXPAND) {
                            NavigatorViewBase.this.toggleNode(viewer, node);
                        } else {
                            NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, node, (IServiceLocator)NavigatorViewBase.this.getSite());
                        }
                    }
                    ++n2;
                }
            }
        });
        NavigatorUtils.addContextMenu((IWorkbenchSite)this.getSite(), (Viewer)navigatorTree.getViewer());
        NavigatorUtils.addDragAndDropSupport((Viewer)navigatorTree.getViewer());
        return navigatorTree;
    }

    private void toggleNode(TreeViewer viewer, Object node) {
        if (Boolean.TRUE.equals(viewer.getExpandedState(node))) {
            viewer.collapseToLevel(node, 1);
        } else {
            viewer.expandToLevel(node, 1);
        }
    }

    protected void onSelectionChange(IStructuredSelection structSel) {
        IEditorPart activeEditor;
        if (!structSel.isEmpty()) {
            this.lastSelection = structSel.getFirstElement();
            if (this.lastSelection instanceof DBNNode) {
                String desc = ((DBNNode)this.lastSelection).getNodeDescription();
                if (CommonUtils.isEmpty((String)desc)) {
                    desc = ((DBNNode)this.lastSelection).getNodeName();
                }
                this.getViewSite().getActionBars().getStatusLineManager().setMessage(desc);
            }
        } else {
            this.lastSelection = null;
        }
        if (this.lastSelection instanceof DBNDatabaseNode && DBeaverCore.getGlobalPreferenceStore().getBoolean("navigator.sync.editor.datasource") && (activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
            NavigatorUtils.syncEditorWithNavigator(this, activeEditor);
        }
    }

    protected int getTreeStyle() {
        return 2;
    }

    public void dispose() {
        this.model = null;
        super.dispose();
    }

    public void setFocus() {
        this.tree.getViewer().getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new PropertyPageStandard());
        }
        return (T)super.getAdapter(adapter);
    }

    public void showNode(DBNNode node) {
        this.tree.showNode(node);
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        Collection containers;
        if (this.lastSelection instanceof DBNDatabaseNode) {
            if (this.lastSelection instanceof DBNDataSource) {
                return ((DBNDataSource)this.lastSelection).getDataSourceContainer();
            }
            if (((DBNDatabaseNode)this.lastSelection).getObject() != null) {
                DBPDataSource dataSource = ((DBNDatabaseNode)this.lastSelection).getObject().getDataSource();
                return dataSource == null ? null : dataSource.getContainer();
            }
        } else if (this.lastSelection instanceof DBNResource && (containers = ((DBNResource)this.lastSelection).getAssociatedDataSources()) != null && containers.size() == 1) {
            return (DBPDataSourceContainer)containers.iterator().next();
        }
        return null;
    }

    public void configureView() {
    }

    public static enum DoubleClickBehavior {
        EDIT,
        CONNECT,
        SQL_EDITOR,
        EXPAND;

    }
}

