/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.indent;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLIndentSymbols;
import org.jkiss.dbeaver.ui.editors.sql.indent.StopCondition;

public class SQLHeuristicScanner
implements SQLIndentSymbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private IDocument _document;
    private String _partitioning;
    private String _partition;
    private SQLSyntaxManager syntaxManager;
    private char _char;
    private int _pos;
    private final StopCondition _nonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition _nonWS = new NonWhitespace();
    private final StopCondition _nonIdent = new NonSQLIdentifierPartDefaultPartition();
    private final DelimiterCondition DELIMITER_CONDITION = new DelimiterCondition();

    public SQLHeuristicScanner(IDocument document, String partitioning, String partition, SQLSyntaxManager syntaxManager) {
        assert (document != null);
        assert (partitioning != null);
        assert (partition != null);
        this._document = document;
        this._partitioning = partitioning;
        this._partition = partition;
        this.syntaxManager = syntaxManager;
    }

    public SQLHeuristicScanner(IDocument document, SQLSyntaxManager syntaxManager) {
        this(document, "___sql_partitioning", "__dftl_partition_content_type", syntaxManager);
    }

    public int getPosition() {
        return this._pos;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this._nonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this._pos;
        if (Character.isJavaIdentifierPart(this._char)) {
            String identOrKeyword;
            int from = pos;
            int to = (pos = this.scanForward(pos + 1, bound, this._nonIdent)) == -1 ? (bound == -2 ? this._document.getLength() : bound) : pos;
            try {
                identOrKeyword = this._document.get(from, to - from);
            }
            catch (BadLocationException e) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 0;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this._nonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this._pos;
        if (Character.isJavaIdentifierPart(this._char)) {
            String identOrKeyword;
            int to = pos + 1;
            int from = (pos = this.scanBackward(pos - 1, bound, this._nonIdent)) == -1 ? (bound == -2 ? 0 : bound + 1) : pos + 1;
            try {
                identOrKeyword = this._document.get(from, to - from);
            }
            catch (BadLocationException e) {
                return -1;
            }
            return this.getToken(identOrKeyword);
        }
        return 0;
    }

    private int getToken(String s) {
        assert (s != null);
        switch (s.length()) {
            case 3: {
                if ("end".equals(s)) {
                    return 1002;
                }
                if (!"END".equalsIgnoreCase(s)) break;
                return 1003;
            }
            case 5: {
                if ("begin".equals(s)) {
                    return 1000;
                }
                if (!"BEGIN".equalsIgnoreCase(s)) break;
                return 1001;
            }
        }
        DBPKeywordType keywordType = this.syntaxManager.getDialect().getKeywordType(s);
        if (keywordType == DBPKeywordType.KEYWORD) {
            return 3000;
        }
        return 0;
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, _nonWS);
    }

    public boolean endsWithDelimiter(int position, int bound) {
        int endPos = this.scanBackward(bound, position, this.DELIMITER_CONDITION);
        try {
            return endPos > position && this.DELIMITER_CONDITION.isDelimiterChar(this._document.getChar(endPos));
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        assert (start >= 0);
        if (bound == -2) {
            bound = this._document.getLength();
        }
        assert (bound <= this._document.getLength());
        try {
            this._pos = start;
            while (this._pos < bound) {
                this._char = this._document.getChar(this._pos);
                if (condition.stop(this._char, this._pos, true)) {
                    return this._pos;
                }
                ++this._pos;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        assert (bound >= -1);
        assert (start < this._document.getLength());
        try {
            this._pos = start;
            while (this._pos > bound) {
                this._char = this._document.getChar(this._pos);
                if (condition.stop(this._char, this._pos, false)) {
                    return this._pos;
                }
                --this._pos;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    public boolean isDefaultPartition(int position) {
        assert (position >= 0);
        assert (position <= this._document.getLength());
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)this._document, (String)this._partitioning, (int)position, (boolean)false);
            return region.getType().equals(this._partition);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int findOpeningPeer(int start, int openingPeer, int closingPeer) {
        assert (start < this._document.getLength());
        int depth = 1;
        int offset = ++start;
        do {
            int token = this.previousToken(offset, -2);
            offset = this.getPosition();
            if (token == -1) {
                return -1;
            }
            if (this.isSameToken(token, closingPeer)) {
                ++depth;
                continue;
            }
            if (!this.isSameToken(token, openingPeer)) continue;
            --depth;
        } while (depth != 0);
        if (offset == -1) {
            return 0;
        }
        return offset;
    }

    public int findClosingPeer(int start, int openingPeer, int closingPeer) {
        assert (start <= this._document.getLength());
        int depth = 1;
        int offset = ++start;
        do {
            int token = this.nextToken(offset, this._document.getLength());
            offset = this.getPosition();
            if (token == -1) {
                return -1;
            }
            if (this.isSameToken(token, openingPeer)) {
                ++depth;
                continue;
            }
            if (!this.isSameToken(token, closingPeer)) continue;
            --depth;
        } while (depth != 0);
        return offset;
    }

    public boolean isSameToken(int firstToken, int secondToken) {
        return firstToken == secondToken || firstToken == 1001 && secondToken == 1000 || firstToken == 1000 && secondToken == 1001 || firstToken == 1003 && secondToken == 1002 || firstToken == 1002 && secondToken == 1003;
    }

    private class DelimiterCondition
    implements StopCondition {
        private DelimiterCondition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return this.isDelimiterChar(ch) || !Character.isWhitespace(ch);
        }

        private boolean isDelimiterChar(char ch) {
            String[] stringArray = SQLHeuristicScanner.this.syntaxManager.getStatementDelimiters();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String delim = stringArray[n2];
                if (delim.length() == 1 && delim.charAt(0) == ch) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class NonSQLIdentifierPart
    implements StopCondition {
        private NonSQLIdentifierPart() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isJavaIdentifierPart(ch);
        }
    }

    private class NonSQLIdentifierPartDefaultPartition
    extends NonSQLIdentifierPart {
        private NonSQLIdentifierPartDefaultPartition() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }

    private static class NonWhitespace
    implements StopCondition {
        private NonWhitespace() {
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        @Override
        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && SQLHeuristicScanner.this.isDefaultPartition(position);
        }
    }
}

