/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.generator.GenerateSQLContributor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class OpenObjectConsoleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        DBPDataSourceContainer ds = null;
        List<DBSObject> selectedObjects = NavigatorUtils.getSelectedObjects(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
        for (DBSObject object : selectedObjects) {
            ds = object.getDataSource().getContainer();
            if (!(object instanceof DBSEntity)) continue;
            entities.add((DBSEntity)object);
        }
        GenerateSQLContributor.SQLGenerator<DBSEntity> generator = GenerateSQLContributor.SELECT_GENERATOR(entities, true);
        this.openConsole(workbenchWindow, generator, ds, "Query", !entities.isEmpty());
        return null;
    }

    protected void openConsole(IWorkbenchWindow workbenchWindow, DBRRunnableWithResult<String> generator, DBPDataSourceContainer ds, String title, final boolean doRun) {
        UIUtils.runInUI((IRunnableContext)workbenchWindow, generator);
        String sql = (String)generator.getResult();
        final SQLEditor editor = OpenHandler.openSQLConsole(workbenchWindow, ds, title, sql);
        if (editor != null) {
            AbstractJob execJob = new AbstractJob("Execute SQL in console"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    int i = 0;
                    while (i < 100) {
                        if (editor.getExecutionContext() != null) break;
                        RuntimeUtils.pause((int)100);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            execJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    UIUtils.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (doRun) {
                                editor.processSQL(false, false);
                            }
                        }
                    });
                }
            });
            execJob.schedule();
        }
    }
}

