/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.utils.CommonUtils;

public class EditDictionaryPage
extends AttributesSelectorPage {
    private Text criteriaText;
    private DBVEntity dictionary;
    private Collection<DBSEntityAttribute> descColumns;
    private DBSEntity entity;

    public EditDictionaryPage(String title, final DBSEntity entity) {
        super(title, entity);
        this.entity = entity;
        this.dictionary = DBVUtils.findVirtualEntity((DBSEntity)entity, (boolean)true);
        UIUtils.runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    Collection tablePK;
                    if (EditDictionaryPage.this.dictionary.getDescriptionColumnNames() == null && (tablePK = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)entity)) != null && !tablePK.isEmpty()) {
                        EditDictionaryPage.this.dictionary.setDescriptionColumnNames(DBVEntity.getDefaultDescriptionColumn((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)tablePK.iterator().next())));
                    }
                    EditDictionaryPage.this.descColumns = EditDictionaryPage.this.dictionary.getDescriptionColumns(monitor, entity);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    public DBVEntity getDictionary() {
        return this.dictionary;
    }

    @Override
    protected void createContentsBeforeColumns(Composite panel) {
        Label label = UIUtils.createControlLabel((Composite)panel, (String)"Choose dictionary description columns or set custom criteria");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    @Override
    protected void createContentsAfterColumns(Composite panel) {
        Group group = UIUtils.createControlGroup((Composite)panel, (String)"Custom criteria", (int)1, (int)768, (int)0);
        this.criteriaText = new Text((Composite)group, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        this.criteriaText.setLayoutData((Object)gd);
        if (!CommonUtils.isEmpty((String)this.dictionary.getDescriptionColumnNames())) {
            this.criteriaText.setText(this.dictionary.getDescriptionColumnNames());
        }
    }

    @Override
    public boolean isColumnSelected(DBSEntityAttribute attribute) {
        return this.descColumns.contains(attribute);
    }

    @Override
    protected void handleColumnsChange() {
        this.descColumns = this.getSelectedAttributes();
        StringBuilder custom = new StringBuilder();
        for (DBSEntityAttribute column : this.descColumns) {
            if (custom.length() > 0) {
                custom.append(",");
            }
            custom.append(DBUtils.getQuotedIdentifier((DBSObject)column));
        }
        this.criteriaText.setText(custom.toString());
    }

    @Override
    public boolean isPageComplete() {
        if (!CommonUtils.isEmpty((String)this.criteriaText.getText())) {
            return true;
        }
        return super.isPageComplete();
    }

    @Override
    protected void performFinish() {
        this.dictionary.setDescriptionColumnNames(this.criteriaText.getText());
        this.entity.getDataSource().getContainer().persistConfiguration();
    }
}

