/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.e4;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.RenameHandler;

public class DBeaverStackRenderer
extends StackRenderer {
    protected void populateTabMenu(Menu menu, MPart part) {
        IEditorInput editorInput;
        File localFile;
        super.populateTabMenu(menu, part);
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        if (workbenchPart instanceof IEditorPart && (localFile = EditorUtils.getLocalFileFromInput(editorInput = ((IEditorPart)workbenchPart).getEditorInput())) != null) {
            this.populateFileMenu(menu, workbenchPart, EditorUtils.getFileFromInput(editorInput), localFile);
        }
    }

    private void populateFileMenu(@NotNull Menu menu, final @NotNull IWorkbenchPart workbenchPart, final @Nullable IFile inputFile, final @NotNull File file) {
        new MenuItem(menu, 2);
        MenuItem menuItemOpenFolder = new MenuItem(menu, 0);
        menuItemOpenFolder.setText("Open Folder in Explorer");
        menuItemOpenFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (file.getParentFile().isDirectory()) {
                    UIUtils.launchProgram((String)file.getParentFile().getAbsolutePath());
                }
            }
        });
        MenuItem menuItemOthers = new MenuItem(menu, 0);
        menuItemOthers.setText("Copy File Path");
        menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filePath = file.getAbsolutePath();
                UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)filePath);
            }
        });
        if (inputFile != null) {
            menuItemOthers = new MenuItem(menu, 0);
            String renameText = "Rename File";
            if (workbenchPart instanceof SQLEditor) {
                renameText = String.valueOf(renameText) + "\t" + ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.rename", (IServiceLocator)workbenchPart.getSite(), (boolean)true);
            }
            menuItemOthers.setText(renameText);
            menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RenameHandler.renameFile(workbenchPart, inputFile, "file");
                }
            });
        }
    }

    private IWorkbenchPart getWorkbenchPart(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityPart) {
            return ((CompatibilityPart)clientObject).getPart();
        }
        return null;
    }
}

