/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.sql;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.sql.BaseSQLDialog;

public class ViewSQLDialog
extends BaseSQLDialog {
    private static final String DIALOG_ID = "DBeaver.ViewSQLDialog";
    private DBCExecutionContext context;
    private String text;
    private boolean showSaveButton = false;
    private boolean enlargeViewPanel = true;
    private boolean wordWrap = false;

    public ViewSQLDialog(IWorkbenchPartSite parentSite, @Nullable DBCExecutionContext context, String title, @Nullable DBPImage image, String text) {
        super(parentSite, title, image);
        this.context = context;
        this.text = text;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    public void setShowSaveButton(boolean showSaveButton) {
        this.showSaveButton = showSaveButton;
    }

    public void setEnlargeViewPanel(boolean enlargeViewPanel) {
        this.enlargeViewPanel = enlargeViewPanel;
    }

    @Override
    protected boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite sqlPanel = this.createSQLPanel(composite);
        GridData gd = (GridData)sqlPanel.getLayoutData();
        if (this.enlargeViewPanel) {
            gd.widthHint = 500;
            gd.heightHint = 400;
        } else {
            gd.widthHint = 400;
            gd.heightHint = 100;
        }
        return sqlPanel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.showSaveButton) {
            this.createButton(parent, 10, CoreMessages.dialog_view_sql_button_persist, true);
            this.createCopyButton(parent);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.createCopyButton(parent);
            this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        }
    }

    @Override
    protected String getSQLText() {
        return this.text;
    }

    public void setSQLText(String text) {
        this.text = text;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 10) {
            this.setReturnCode(10);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    @Override
    protected DBCExecutionContext getExecutionContext() {
        return this.context;
    }
}

